/**
 * 文件名： AdvertTag.java 此类描述的是： 作者: zufengze 创建时间: 2016年4月11日 下午2:24:30
 */
package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告标签实体对象.
 *
 * @author: zufengze
 * @version:
 */
public class AdvertTagDto implements Serializable {
    /**
     * The Constant serialVersionUID. @ZFZ
     */
    private static final long serialVersionUID = -7260813558978757963L;

    /**
     * 沿用广告标签
     */
    public static final String FOLLOW_ADVERT_BANNED_TAG_TYPE = "-2";

    /**
     * 广告标签列表， 逗号隔开.
     */
    private String matchTagNums;

    /**
     * 默认配置屏蔽标签列表， 逗号隔开.
     */
    private String bannedTagNums;

    /**
     * 广告id
     */
    private Long advertId;

    /** 广告屏蔽标签 */
    private String advertBannedTagNums;

    /**
     * 兼容以前的
     */
    private String tags;

    public String getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(String matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public String getBannedTagNums() {
        return bannedTagNums;
    }

    public void setBannedTagNums(String bannedTagNums) {
        this.bannedTagNums = bannedTagNums;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public static String getFollowAdvertBannedTagType() {
        return FOLLOW_ADVERT_BANNED_TAG_TYPE;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertBannedTagNums() {
        return advertBannedTagNums;
    }

    public void setAdvertBannedTagNums(String advertBannedTagNums) {
        this.advertBannedTagNums = advertBannedTagNums;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
