package cn.com.duiba.tuia.core.api.dto.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;


@ApiModel("聚合媒体规则查询")
public class CollectAppRuleReq implements Serializable {

    private static final long serialVersionUID = 1;

    @ApiModelProperty("当前日期：yyyy-MM-dd")
    private String curDate;

    @ApiModelProperty("聚合规则类型：1-消耗；2-发券")
    private Integer collectType;

    @ApiModelProperty("聚合规则平均类型：1-7日平均")
    private Integer avgType;

    @ApiModelProperty("聚合筛选规则：1-小于；2-大于")
    private Integer type;

    @ApiModelProperty("聚合规则值")
    private Long collectValue;

    @ApiModelProperty("媒体行业标签：一级标签")
    private Long tradeOneTag;

    @ApiModelProperty("媒体行业标签：二级标签")
    private Long tradeTwoTag;

    @ApiModelProperty("聚合媒体名称")
    private String collectAppName;

    @ApiModelProperty("媒体id列表")
    private String appIds;

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public Integer getCollectType() {
        return collectType;
    }

    public void setCollectType(Integer collectType) {
        this.collectType = collectType;
    }

    public Long getCollectValue() {
        return collectValue;
    }

    public void setCollectValue(Long collectValue) {
        this.collectValue = collectValue;
    }

    public Long getTradeOneTag() {
        return tradeOneTag;
    }

    public void setTradeOneTag(Long tradeOneTag) {
        this.tradeOneTag = tradeOneTag;
    }

    public Long getTradeTwoTag() {
        return tradeTwoTag;
    }

    public void setTradeTwoTag(Long tradeTwoTag) {
        this.tradeTwoTag = tradeTwoTag;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCollectAppName() {
        return collectAppName;
    }

    public void setCollectAppName(String collectAppName) {
        this.collectAppName = collectAppName;
    }

    public String getAppIds() {
        return appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public Integer getAvgType() {
        return avgType;
    }

    public void setAvgType(Integer avgType) {
        this.avgType = avgType;
    }
}
