package cn.com.duiba.tuia.core.api.enums;

/**
 * @author fanjia
 * @date 2021年09月18日 下午1:53
 */
public enum AccountChangeTaskStateTypeEnum {
    TASK_SUBMIT(0,"工单已提交","通知:自动迁户-前置条件\n 广告主ID:%s ,迁户工单已审批通过,账户已完成清零,预计%s将进行自动迁户请知悉;"),
    TASK_OK(1,"迁户成功","通知:自动迁户正常完成\n 原代理商ID:%s,广告主ID:%s,新代理商ID:%s。广告主已归属新的代理商,请知悉并开启下一段投放旅程吧;" ),
    NO_FIRST_CHANGE(2,"非首次迁户","告警:自动迁户-前置条件\n 广告主ID:%s ,迁户工单已审批通过,该广告主非首次迁户,无法进入自动迁户,请相关人员及时跟进处理;"),
    DINGTALK_INFO_ERROR(3,"钉钉工单信息错误","告警:自动迁户-前置条件\n 广告主ID:%s ,迁户工单已审批通过,广告主/代理商信息有误,无法进入自动迁户；请相关人员及时跟进处理;"),
    MONEY_NO_ZERO(4,"账户没有及时清零","告警:自动迁户-前置条件\n 广告主ID:%s ,迁户工单已审批通过,账户未清零,无法进入自动迁户；请相关人员及时跟进处理;"),
    MONEY_ZERO(5,"账户清零","通知:自动迁户-前置条件\n 广告主ID:%s,迁户工单已审批通过,账户已完成清零,预计%s将进行自动迁户,请知悉;"),
    ACCOUNT_FREEZE(6,"账户自动冻结","通知:自动迁户「账户冻结正常完成」\n 进度:1/4,原代理商ID:%s,广告主ID:%s;"),
    ACCOUNT_FREEZE_ERROR(7,"账户自动冻结异常","告警:自动迁户「账户自动冻结异常」\n 进度:1/4,原代理商ID:%s,广告主ID:%s,自动迁户已中断,请相关人员及时跟踪解决;"),
    DMP_SYNC(8,"DMP数据回流,数据同步成功","通知:自动迁户「数据同步正常完成」\n 进度:2/4;"),
    DMP_SYNC_ERROR(9,"DMP数据回流失败","告警:自动迁户「数据同步异常」\n 原因:数据同步异常,进度:2/4,请相关人员及时跟踪解决;"),
    artificial(10,"人工触发完成","通知:自动迁户「人工触发完成」\n 进度:2/4,原代理商ID:%s,广告主ID:%s;"),
    invalid(11,"终止","告警:自动迁户「终止」\n 原因:未在规定时间内进行人工触发,进度:2/4,原代理商ID:%s,广告主ID:%s;"),
    CHANGE_ACCOUNT(12,"修改映射关系成功","通知:自动迁户「映射关系修改正常完成」\n 进度:3/4,原代理商ID:%s,广告主ID:%s;"),
    CHANGE_ACCOUNT_ERROR(13,"修改映射关系失败","告警:自动迁户「映射关系修改异常」\n 原因:映射关系修改异常,进度:3/4,原代理商ID:%s,广告主ID:%s,自动迁户已中断,请相关人员及时跟踪解决;"),
    ACCOUNT_UNFREEZE(14,"广告主账户解冻成功","通知:自动迁户「广告主账户解冻正常完成」\n,进度:4/4,原代理商ID:%s,广告主ID:%s"),
    ACCOUNT_UNFREEZE_ERROR(15,"广告主账户解冻异常","告警:自动迁户「广告主账户解冻异常」\n原因:广告主账户解冻异常,进度:4/4,原代理商ID:%s,广告主ID:%s,自动迁户已中断,请相关人员及时跟踪解决;"),
    ;

    private Integer state;

    private String name;

    private String dingdingContent;

    public Integer getState() {
        return state;
    }


    public String getName() {
        return name;
    }

    public String getDingdingContent() {
        return dingdingContent;
    }


    AccountChangeTaskStateTypeEnum(Integer state, String name, String dingdingContent) {
        this.state = state;
        this.name = name;
        this.dingdingContent = dingdingContent;
    }
}
