package cn.com.duiba.tuia.core.api.enums;

import java.util.stream.Stream;

/**
 * 广告应用包名的使用类型
 *
 * @Author chensong
 * @Create 2019-01-21
 */
public enum AdvertAppPackageUseType {

    /** 天天快报 */
    TTKB(1, "天天快报"),

    /** 趣闻 */
    QUWEN(2, "趣闻");

    /** 类型代码 */
    private int code;

    /** 描述 */
    private String desc;

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    AdvertAppPackageUseType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据类型代码获取枚举
     *
     * @param code
     * @return
     */
    public static AdvertAppPackageUseType getByCode(Integer code){
        if (code == null) {
            return null;
        }
        return Stream.of(AdvertAppPackageUseType.values())
                     .filter(value -> value.getCode() == code)
                     .findFirst()
                     .orElse(null);
    }


}
