/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteItemService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年11月9日上午11:12:59<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertNewTradeDto;
import cn.com.duiba.tuia.core.api.dto.advert.TagNewTradeDto;
import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;

import java.util.List;

/**
 * ClassName: RemoteTagNewTradeService <br/>
 * date: 2019年11月8日 上午11:12:59 <br/>
 * .
 *
 * @author lijian
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteTagNewTradeService {

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Integer insert(TagNewTradeDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(TagNewTradeDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 分页查询新行业标签关系记录
     *
     * @param req 查询条件
     * @return
     */
    PageDto<TagNewTradeDto> queryPage(BaseQueryReq req);


    List<TagNewTradeDto> queryNewTrade();

    /**
     * 根据新行业查询数据
     *
     * @param newTrade
     * @return
     */
    TagNewTradeDto getByNewTrade(String newTrade);

    /**
     * 获取当前最大的新行业ID
     *
     * @return
     */
    Integer getMaxTradeTagId();

    /**
     * 根据新行业ID列表 查询关联标签数量
     *
     * @param tradeTagIds
     * @return
     */
    Integer getByTradeTagIds(List<Integer> tradeTagIds);

    /**
     * 根据标签标识查询该标签是否已关联新行业
     *
     * @param tagNum
     * @return
     */
    String selectByTagNum(String tagNum);

    /**
     * 根据新行业id删除关联的标签
     * @param tradeTagId
     * @return
     */
    Integer deleteByTradeTagId(Integer tradeTagId);

    /**
     * 获取广告对应的新行业
     * @param advertIds
     * @return
     */
    List<AdvertNewTradeDto> getAdvertNewTradeByAdvertIds(List<Long> advertIds);

    List<Long> queryAdvertIdsByNewTrade(String newTrade);

    /**
     * 新增或更新广告对应的新行业
     * @return
     */
    Integer saveOrUpdateAdvertNewTrade(AdvertNewTradeDto param);

    /**
     * 获取所有到新行业标签
     * @return
     */
    List<TagNewTradeDto> getAllTagNewTrade();
}
