package cn.com.duiba.tuia.core.api.remoteservice.mct;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.mct.MaterialClassifyTagMappingDTO;
import cn.com.duiba.tuia.core.api.dto.mct.MaterialClassifyTagMappingFormDTO;
import cn.com.duiba.tuia.core.api.dto.mct.MaterialClassifyTagMappingQueryDTO;

import java.util.List;

/**
 * 素材和分类标签关联表 RemoteService
 * @author Wpf
 * @since 2023-11-10
 */
@AdvancedFeignClient
public interface RemoteMaterialClassifyTagMappingService {

    MaterialClassifyTagMappingDTO queryById(Long id);

    List<MaterialClassifyTagMappingDTO> queryList(MaterialClassifyTagMappingQueryDTO queryDTO);

    long queryCount(MaterialClassifyTagMappingQueryDTO queryDTO);

    int save(MaterialClassifyTagMappingFormDTO formDTO);

    int insertBatch(List<MaterialClassifyTagMappingFormDTO> formDTOs);

    /**
     * 根据素材Id 清理掉之前的绑定关系
     *
     * @param materialId
     */
    int clearByMaterialId(List<Long> materialIds);

    List<MaterialClassifyTagMappingDTO> selectByMaterialIds(List<Long> materialIds);
}
