package cn.com.duiba.tuia.core.api.remoteservice.rta;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.rta.RtaOfflineTaskAdvertiserMappingDTO;
import cn.com.duiba.tuia.core.api.dto.rta.RtaOfflineTaskConfigDTO;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/9/22
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteRtaOfflineTaskConfigService {
    /**
     * 添加任务
     * @param rtaOfflineTaskConfigDTO
     * @return
     */
    Boolean addTask(RtaOfflineTaskConfigDTO rtaOfflineTaskConfigDTO);

    /**
     * 分页查询
     * @param rtaOfflineTaskConfigDTO
     * @return
     */
    PageDto<RtaOfflineTaskConfigDTO> queryTaskList(RtaOfflineTaskConfigDTO rtaOfflineTaskConfigDTO);

    /**
     * 查询明细
     * @param id
     * @return
     */
    RtaOfflineTaskConfigDTO queryById(Long id);

    /**
     * 更新任务
     * @param rtaOfflineTaskConfigDTO
     * @return
     */
    Boolean updateTask(RtaOfflineTaskConfigDTO rtaOfflineTaskConfigDTO);

    /**
     * 通过taskId查询记录数量
     * @param advertiserIds
     * @param id
     * @return
     */
    Integer queryCountByAdvertiserIds(List<Long> advertiserIds, Long id);

    /**
     * 通过复合条件查询
     * @param rtaOfflineTaskConfigDTO
     * @return
     */
    List<RtaOfflineTaskConfigDTO> queryByCondition(RtaOfflineTaskConfigDTO rtaOfflineTaskConfigDTO);

    /**
     * 通过id查询 这个接口做了缓存
     * @param id 主键
     * @return
     */
    RtaOfflineTaskConfigDTO queryConfigCacheById(Long id);
}
