package cn.com.duiba.tuia.core.api.dto.land;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.util.List;

/**
 * 落地页跳转链接Dto对象
 *
 * @Author chensong
 * @Create 2018-12-26
 */
public class LandJumpUrlDto extends BaseDto {

    /** 广告id */
    private Long advertId;

    /** 落地页url */
    private String promoteUrl;

    /** 落地页代码的md5摘要 */
    private String landMd5;

    /** 跳转url */
    private List<String> jumpUrl;

    /**
     * 落地页二跳类型
     */
    private int type;

    /**
     * 落地页ID
     */
    private Long urlId;

    private String secondJumpScreenshot;

    public LandJumpUrlDto() {
    }

    public LandJumpUrlDto(Long advertId, String promoteUrl, String landMd5, List<String> jumpUrl) {
        this.advertId = advertId;
        this.promoteUrl = promoteUrl;
        this.landMd5 = landMd5;
        this.jumpUrl = jumpUrl;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getLandMd5() {
        return landMd5;
    }

    public void setLandMd5(String landMd5) {
        this.landMd5 = landMd5;
    }

    public List<String> getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(List<String> jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getUrlId() {
        return urlId;
    }

    public void setUrlId(Long urlId) {
        this.urlId = urlId;
    }

    public String getSecondJumpScreenshot() {
        return secondJumpScreenshot;
    }

    public void setSecondJumpScreenshot(String secondJumpScreenshot) {
        this.secondJumpScreenshot = secondJumpScreenshot;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }
}
