/**
 * 文件名： UpdateCouponReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月12日 下午2:03:36
 */
package cn.com.duiba.tuia.core.api.dto.req;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 修改优惠券请求
 *
 * @author: leiliang
 * @version:
 */
public class ReqUpdateCouponDto implements Serializable {

    private static final long        serialVersionUID     = 1L;

    /** 投放端调用. */
    public static final int          CALL_TYPE_OF_TUIA    = 0;

    /** 管理端调用. */
    public static final int          CALL_TYPE_OF_MANAGER = 1;

    /** 广告ID. */
    private Long                     advertId;

    private Boolean                  isCheckPass;

    /** 推广网址. */
    private String                   promoteURL;

    /** 商品名称. */
    private String                   couponName;


    /** 品牌图标. */
    private String                   thumbnailPng;

    /** 首页banner图. */
    private String                   bannerPng;

    /** 领取次数限制. */
    private Integer                  limitReceive;

    /** 优惠码类型. */
    private Integer                  codeType;

    /**
     * 更随投放时段
     */
    private int followThrowDate = 1;

    /** 调用端：(0：投放端，1：管理端). */
    private int                      callType;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(false：否，true：是). */
    private boolean                  specialHide;

    /**
     * 是否为微信券. 是否为微信券(false：否，true：是) (只有code_type=2 or code_type=3时有效) 字段名 字段类型 是否必填 字段说明 .
     */
    private boolean                  isWeixin;

    private List<String>             matchTagNums;

    /** 按钮文案. */
    private String buttonText;

    /**
     * 素材设计师
     */
    private String designer;

    private Date editTime;

    /** "推广链接类型 1：落地页网址，2：落地页名称 */
    private Integer            promoteType;

    /**
     * 广告对应的应用的名字
     */
    private String  applicationName;

    /**
     * 包名
     */
    private String  appPkgName;

    /**
     * 展示类型
     */
    private Integer styleControl;

    /**
     * 应用图标链接
     */
    private String appIconUri;

    /**
     * 头部标题
     */
    private String title;

    /**
     * 应用描述
     */
    private String desc;

    /**
     * 配置类型
     */
    private Integer configType;

    /**
     * 微信弹窗标题
     */
    private String windowTitle;

    /**
     * 微信弹窗描述
     */
    private String windowDesc;

    /**
     * 微信弹窗Toast文案
     */
    private String toastDesc;

    /**
     * 微信ID
     */
    private String wechatId;

    /**
     * 微信名称
     */
    private String wechatName;

    /**
     * 微信头像
     */
    private String wechatPic;

    /** 深度链接 */
    private String promoteDeepLink;

    /** app下载链接 */
    private String appDownloadUrl;

    /** 推广目的. 0 非应用下载 1 应用下载 */
    private Integer                     expandTarget;

    /**
     * dp广告类型字段，1-》adx广告，2-》dp广告
     */
    private Integer dpAdvertType;

    /** 应用推广图 */
    private List<String> appPro;


    /**
     * 应用信息需求-应用名称
     */
    private String appInfoName;
    /**
     * 应用信息需求-应用版本
     */
    private String appInfoVersion;
    /**
     * '应用信息需求-应用开发者
     */
    private String appInfoDeveloper;
    /**
     * 应用信息需求-应用的包体大小
     */
    private String appInfoPkgSize;
    /**
     * 应用信息需求-应用权限H5链接
     */
    private String appInfoPermissionUrl;
    /**
     * 应用信息需求-应用隐私政策H5链接
     */
    private String appInfoPrivacyUrl;

    /**
     * 新增的uLink链接
     */
    private String promoteULink;

    /**
     * deeplink类型  1单链接  2链接库
     */
    private Integer deepLinkType;
    /**
     * ulink 1单链接  2链接库
     */
    private Integer uLinkType;
    /**
     * ulink链接库id
     */
    private Long uLinkLibrary;
    /**
     * deeplink链接库id
     */
    private Long deepLinkLibrary;

    public Boolean getCheckPass() {
        return isCheckPass;
    }

    public void setCheckPass(Boolean checkPass) {
        isCheckPass = checkPass;
    }

    public String getAppInfoName() {
        return appInfoName;
    }

    public void setAppInfoName(String appInfoName) {
        this.appInfoName = appInfoName;
    }

    public String getAppInfoVersion() {
        return appInfoVersion;
    }

    public void setAppInfoVersion(String appInfoVersion) {
        this.appInfoVersion = appInfoVersion;
    }

    public String getAppInfoDeveloper() {
        return appInfoDeveloper;
    }

    public void setAppInfoDeveloper(String appInfoDeveloper) {
        this.appInfoDeveloper = appInfoDeveloper;
    }

    public String getAppInfoPkgSize() {
        return appInfoPkgSize;
    }

    public void setAppInfoPkgSize(String appInfoPkgSize) {
        this.appInfoPkgSize = appInfoPkgSize;
    }

    public String getAppInfoPermissionUrl() {
        return appInfoPermissionUrl;
    }

    public void setAppInfoPermissionUrl(String appInfoPermissionUrl) {
        this.appInfoPermissionUrl = appInfoPermissionUrl;
    }

    public String getAppInfoPrivacyUrl() {
        return appInfoPrivacyUrl;
    }

    public void setAppInfoPrivacyUrl(String appInfoPrivacyUrl) {
        this.appInfoPrivacyUrl = appInfoPrivacyUrl;
    }

    /**
     * promoteType.
     *
     * @return the promoteType
     * @since JDK 1.8
     */
    public Integer getPromoteType() {
        return promoteType;
    }

    /**
     * promoteType.
     *
     * @param promoteType the promoteType to set
     * @since JDK 1.8
     */
    public void setPromoteType(Integer promoteType) {
        this.promoteType = promoteType;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public List<String> getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(List<String> matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public boolean isSpecialHide() {
        return specialHide;
    }

    public void setSpecialHide(boolean specialHide) {
        this.specialHide = specialHide;
    }

    public boolean isWeixin() {
        return isWeixin;
    }

    public void setWeixin(boolean isWeixin) {
        this.isWeixin = isWeixin;
    }

    public int getCallType() {
        return callType;
    }

    public void setCallType(int callType) {
        this.callType = callType;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Boolean getIsCheckPass() {
        return isCheckPass;
    }

    public void setIsCheckPass(Boolean isCheckPass) {
        this.isCheckPass = isCheckPass;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCodeType() {
        return codeType;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public int getFollowThrowDate() {
        return followThrowDate;
    }

    public void setFollowThrowDate(int followThrowDate) {
        this.followThrowDate = followThrowDate;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAppPkgName() {
        return appPkgName;
    }

    public void setAppPkgName(String appPkgName) {
        this.appPkgName = appPkgName;
    }

    public Integer getStyleControl() {
        return styleControl;
    }

    public void setStyleControl(Integer styleControl) {
        this.styleControl = styleControl;
    }

    public String getAppIconUri() {
        return appIconUri;
    }

    public void setAppIconUri(String appIconUri) {
        this.appIconUri = appIconUri;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getConfigType() {
        return configType;
    }

    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    public String getWindowTitle() {
        return windowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getWindowDesc() {
        return windowDesc;
    }

    public void setWindowDesc(String windowDesc) {
        this.windowDesc = windowDesc;
    }

    public String getToastDesc() {
        return toastDesc;
    }

    public void setToastDesc(String toastDesc) {
        this.toastDesc = toastDesc;
    }

    public String getWechatId() {
        return wechatId;
    }

    public void setWechatId(String wechatId) {
        this.wechatId = wechatId;
    }

    public String getWechatName() {
        return wechatName;
    }

    public void setWechatName(String wechatName) {
        this.wechatName = wechatName;
    }

    public String getWechatPic() {
        return wechatPic;
    }

    public void setWechatPic(String wechatPic) {
        this.wechatPic = wechatPic;
    }

    public String getPromoteDeepLink() {
        return promoteDeepLink;
    }

    public void setPromoteDeepLink(String promoteDeepLink) {
        this.promoteDeepLink = promoteDeepLink;
    }

    public Integer getExpandTarget() {
        return expandTarget;
    }

    public void setExpandTarget(Integer expandTarget) {
        this.expandTarget = expandTarget;
    }

    public String getAppDownloadUrl() {
        return appDownloadUrl;
    }

    public void setAppDownloadUrl(String appDownloadUrl) {
        this.appDownloadUrl = appDownloadUrl;
    }

    public Integer getDpAdvertType() {
        return dpAdvertType;
    }

    public void setDpAdvertType(Integer dpAdvertType) {
        this.dpAdvertType = dpAdvertType;
    }

    public List<String> getAppPro() {
        return appPro;
    }

    public void setAppPro(List<String> appPro) {
        this.appPro = appPro;
    }

    public String getPromoteULink() {
        return promoteULink;
    }

    public void setPromoteULink(String promoteULink) {
        this.promoteULink = promoteULink;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Integer getDeepLinkType() {
        return deepLinkType;
    }

    public void setDeepLinkType(Integer deepLinkType) {
        this.deepLinkType = deepLinkType;
    }

    public Integer getuLinkType() {
        return uLinkType;
    }

    public void setuLinkType(Integer uLinkType) {
        this.uLinkType = uLinkType;
    }

    public Long getuLinkLibrary() {
        return uLinkLibrary;
    }

    public void setuLinkLibrary(Long uLinkLibrary) {
        this.uLinkLibrary = uLinkLibrary;
    }

    public Long getDeepLinkLibrary() {
        return deepLinkLibrary;
    }

    public void setDeepLinkLibrary(Long deepLinkLibrary) {
        this.deepLinkLibrary = deepLinkLibrary;
    }
}
