package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

/**
 * ClassName: ResourceTagsTypeEnum <br/>
 * Function: 资源对应标签类型. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum NewTagsNumEnum {

    /** 行业标签 */
    ADVERT_TAG("02", "广告标签"),
    
    /** 属性标签 */
    BANNED_TAG("03", "属性标签"),
    
    /**落地页标签 */
    PROMOTEURL("04", "落地页标签"),
    PROMOTEURL_PACKAG("04.03", "落地页标签-包装类型"),

    /** 素材标签 */
    MATERIAL("05", "素材标签"),
    MATERIAL_PACKAG("05.02","素材标签-包装类型"),
    
    /** 分析标签 */
    ANALYSIS("06", "分析标签"),

    /** 资源标签 */
    RESOURCE_TAG("07", "资源标签")

    ;

    private String desc;

    private String code;

    NewTagsNumEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, NewTagsNumEnum> enumMap = Maps.newHashMap();
    static {
        for (NewTagsNumEnum it : NewTagsNumEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static NewTagsNumEnum getByName(String code) {
        return enumMap.get(code);
    }

    /**
     *  校验type类型是否支持 并转换成支持映射关系的类型-目前只支持 04.03 05.02
     *  cf:http://cf.dui88.com/pages/viewpage.action?pageId=135838698
     *  注意事项,添加支持类型的时候 需要评估-是否会影响到几处审（广告审核/落地页审核/素材审核)批量打上父子标签/
     * @author fanjia
     * @date 2022/2/10 上午11:22
     * @param tagNumType
     * @return NewTagsNumEnum
     */
    public static NewTagsNumEnum tagLibraryRelationCheck(String tagNumType) {
        NewTagsNumEnum newTagsNumEnum = NewTagsNumEnum.getByName(tagNumType);
        //注意事项,添加支持类型的时候 需要评估-是否会影响到几处审（广告审核/落地页审核/素材审核)批量打上父标签的准确性
        if (NewTagsNumEnum.PROMOTEURL_PACKAG==newTagsNumEnum) {
         return NewTagsNumEnum.PROMOTEURL_PACKAG;
        } else if (NewTagsNumEnum.MATERIAL_PACKAG==newTagsNumEnum) {
            return NewTagsNumEnum.MATERIAL_PACKAG;
        } else {
           return null;
        }
    }

    public static boolean isResourceTag(String tag) {
        if (StringUtils.isBlank(tag)) {
            return false;
        }

        return tag.startsWith(RESOURCE_TAG.getCode());
    }
}
