package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.*;
import cn.com.duiba.tuia.core.api.dto.req.PromoteTestCheckReq;
import cn.com.duiba.tuia.core.api.dto.rsp.promotetest.AdvertPromoteTestDto;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@AdvancedFeignClient
public interface RemoteAuditRecordsDataService {

    /**
     * 查询符合条件的账号审核记录总条数
     */
    Integer queryAccountAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的账号审核记录
     */
    List<AccountAuditDataDto> queryAccountAuditData(AuditRecordsFilterItemsDto dto);

    /**
     * 查询 账号审核 记录关联的一些扩展信息
     * @return
     */
    AccountCheckRecordDto queryAccountAuditExtData(Long accountId);




    /**
     * 查询符合条件的资质审核记录总条数
     */
    Integer queryQualificationsAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的资质审核记录
     */
    List<QualificationsAuditDataDto> queryQualificationsAuditData(AuditRecordsFilterItemsDto dto);
    /**
     * 查询扩展数据
     */
    QualificationsAuditDataDto queryQualificationsAuditExtData(Long accountId);
    /**
     * 批量插入 资质审核记录
     */
    Integer batchInsertQualificationsAuditData(List<QualificationsAuditDataDto> dtos);




    /**
     * 查询符合条件的落地页审核记录总条数
     */
    Integer queryLandAuditDataCount(AuditRecordsFilterItemsDto dto);

    /**
     * 查询符合条件的落地页审核记录
     */
    List<LandAuditDataDto> queryLandAuditData(AuditRecordsFilterItemsDto dto);
    /**
     * 根据广告id 查询扩展数据
     * @param advertId
     * @return
     */
    LandAuditDataDto queryLandAuditExtData(Long advertId);
    /**
     * 插入 测试落地页审核记录
     */
    Integer insertLandAuditData(LandAuditDataDto dto);




  /** 给钟馗审核记录落地页更新截图-异步
   *
   * @author fanjia
   * @date 2021/11/6 上午9:05
   * @param riskSourceId
   * @param promoteUrl
   * @param advertId
   * @param ifFullPage
   */
     void updateRiskRecordPromoteImgRulAnys(Long riskSourceId,String promoteUrl,Long advertId,Boolean ifFullPage);

    /**
     * 查询符合条件的素材审核记录总条数
     */
    Integer queryMaterialAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的素材审核记录
     */
    List<MaterialAuditDataDto> queryMaterialAuditData(AuditRecordsFilterItemsDto dto);


    /**
     * 查询扩展数据
     */
    MaterialAuditDataDto queryMaterialAuditExtData(MaterialAuditDataDto materialCheckRecordDO);


    /** 根据行业名称和资质名称名称做条件查询条数
     *
     */
     Integer queryCountByQualificationNameAndIndustry(AuditRecordsFilterItemsDto dto) ;

    /**
     * 根据行业名称和资质名称名称做条件分页查询
     */

    List<QualificationsAuditDataDto> queryPageByQualificationNameAndIndustry(AuditRecordsFilterItemsDto dto) ;


    /**
     * 根据落地页id集合查询
     */
    List<LandAuditDataDto> listLandAuditDataDtoByLandPageIdList(List<Long> landPageIdList);


    /**
     *  根据落地页id +创建记录时间 查询审核记录
     * @author fanjia
     * @date 2021/11/4 下午3:22
     * @param landPageId   落地页id
     * @param createTime   创建审核记录时间
     * @return cn.com.duiba.tuia.core.api.dto.LandAuditDataDto
     */
    Optional<LandAuditDataDto> getByLandPageIdAndCreateTime(Long landPageId, Date createTime);





}
