/**
 * Project Name:tuia-core-api<br>
 * File Name:BaseAdvertDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年8月22日下午1:55:37<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

/**
 * ClassName: BaseAdvertDto <br/>
 * Function: 基本信息. <br/>
 * date: 2016年8月22日 下午1:55:37 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class BaseAccountDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** ID. */
    private Long              id;

    /** 邮箱. */
    private String            email;

    /** 公司名称. */
    private String            name;

    /** 代理商id */
    private Long              agentId;

    /** 代理商名称 */
    private String              agentName;

    /** 代理商(广告主)等级 0为最顶级 */
    private Integer           accountLevel;

    /** 上级代理商层级连接，点分隔 */
    private String            accountLevelNum;

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * The Constructor.
     *
     * @param id the id
     * @param email the email
     * @param name the name
     */
    public BaseAccountDto(Long id, String email, String name) {
        super();
        this.id = id;
        this.email = email;
        this.name = name;
    }

    /**
     * The Constructor.
     */
    public BaseAccountDto() {
        super();
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the name.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getAccountLevel() {
        return accountLevel;
    }

    public void setAccountLevel(Integer accountLevel) {
        this.accountLevel = accountLevel;
    }

    public String getAccountLevelNum() {
        return accountLevelNum;
    }

    public void setAccountLevelNum(String accountLevelNum) {
        this.accountLevelNum = accountLevelNum;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseInfoDto [id=");
        builder.append(id);
        builder.append(", email=");
        builder.append(email);
        builder.append(", name=");
        builder.append(name);
        builder.append("]");
        return builder.toString();
    }

}
