package cn.com.duiba.tuia.core.api.dto.compensate;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 广告配置赔付DTO
 *
 * @author peanut.huang
 * @date 2019/10/14
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class CompensatePackageDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = -7051028912101179349L;

    /**
     * 计划id
     */
    private Long        advertId;

    /**
     * 配置id
     */
    private Long        pkgId;

    /**
     * 赔付量级
     */
    private Long        compensateLevel;

    /**
     * 赔付金额
     */
    private Long        compensateAmount;

    /**
     * 目标成本
     */
    private Long        targetCost;

    /**
     * 转化成本
     */
    private Long        transferCost;

    /**
     * 成本异常百分比：(转化成本-目标成本)/目标成本
     */
    private Integer     expRate;




    /**
     *  所有的优化目标-目标成本 格式1-200,2-300,3-100多个用逗号分隔'
     * @author fanjia
     * @date 2022/2/18 下午5:33
     * @param null
     * @return null
     */
    private String subTypePriceDetail;
}
