package cn.com.duiba.tuia.core.api.dto.jfsite;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2020-07-24
 */
@Setter
@Getter
public class JfAlarmPersonDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    protected Long id;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "手机")
    private String mobile;

    @ApiModelProperty(value = "姓名")
    private String name;

    @Override
    public int hashCode() {
        return id == null ? super.hashCode() : id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JfAlarmPersonDTO) {
            JfAlarmPersonDTO that = (JfAlarmPersonDTO) obj;
            if (that.getId() != null && id != null && that.getId().equals(id)) {
                return true;
            }
        }
        return false;
    }

}
