package cn.com.duiba.tuia.core.api.dto.rsp.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 广告主资质查询记录表
 * </p>
 *
 * @author chl
 * @since 2021-10-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class QualificationQueryRecordDto {

    private static final long serialVersionUID = 1L;

    /**
     * 记录id
     */
    private String recordId;

    /**
     * 查询日期
     */
    private Date queryDate;

    /**
     * 筛选开始日期
     */
    private Date startDate;

    /**
     * 筛选结束日期
     */
    private Date endDate;

    private Long advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 行业id
     */
    private Long tradeId;

    /**
     * 行业名称
     */
    private String tradeName;

    /**
     * 水印文案
     */
    private String watermarkText;

    /**
     * 资质名称
     */
    private String qualificationName;

    /**
     * 资质筛选
     */
    private String qualificationFilter;

    /**
     * 查询条件的消耗金额
     */
    private BigDecimal consumeAmount;
    /**
     * ae姓名
     */
    private String aeName;
    /**
     * 销售名称
     */
    private String sellName;

    /**
     * 查的条数
     */
    private Integer resultNum;

    /**
     * 查询人
     */
    private String operator;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 广告主id
     */
    private Long accountId;

    private Boolean isCreating = false;


}
