package cn.com.duiba.tuia.core.api.dto.statistics;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

import java.util.Date;

/**
 * Created by huangch on 2017/12/07 15:25
 * description: 素材诊断DO
 *
 * @since JDK 1.6
 */
public class MaterialDiagnosticMergeOutHlDto extends BaseDto {
    private static final long serialVersionUID = 5762101332909531927L;
    //诊断的数据日期
    private Date curDate;
    //素材id
    private Long materialId;
    //素材名称
    private String materialName;
    //素材的创建时间
    private Date startDate;
    //素材ctr诊断结果,如：好、差、一般、很差、不确定等
    private String diagnosticResultCtr;
    //ctr诊断的详细内容
    private String comDiagnosticContentCtr2;
    //素材cvr诊断结果,如：好、差、一般、很差、不确定等
    private String diagnosticResultCvr;
    //cvr诊断的详细内容
    private String comDiagnosticContentCvr2;
    //同行业流量ctr样本的数量
    private String sampleCntCtr;
    //同行业同流量样本ctr(比较样本的平均ctr)
    private String ctrSamples;
    //同行业流量cvr样本的数量
    private String sampleCntCvr;
    //同行业同流量样本cvr(比较样本的平均cvr)
    private String cvrSamples;
    //同流量下的ctr top1的素材id,如果为0表示该流量下只有当前一种素材
    private String topMa2T;
    //topMa2的发券量
    private String sumLaunchCntMa2;
    //同流量下的ctr top1的素材的ctr
    private String ctrMostMa2;
    //同流量下的cvr top1的素材id,如果为0表示该流量下只有当前一种素材
    private String topMa2V;
    //同流量下的cvr top1的素材的cvr
    private String cvrMostMa2;

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getDiagnosticResultCtr() {
        return diagnosticResultCtr;
    }

    public void setDiagnosticResultCtr(String diagnosticResultCtr) {
        this.diagnosticResultCtr = diagnosticResultCtr;
    }

    public String getComDiagnosticContentCtr2() {
        return comDiagnosticContentCtr2;
    }

    public void setComDiagnosticContentCtr2(String comDiagnosticContentCtr2) {
        this.comDiagnosticContentCtr2 = comDiagnosticContentCtr2;
    }

    public String getDiagnosticResultCvr() {
        return diagnosticResultCvr;
    }

    public void setDiagnosticResultCvr(String diagnosticResultCvr) {
        this.diagnosticResultCvr = diagnosticResultCvr;
    }

    public String getComDiagnosticContentCvr2() {
        return comDiagnosticContentCvr2;
    }

    public void setComDiagnosticContentCvr2(String comDiagnosticContentCvr2) {
        this.comDiagnosticContentCvr2 = comDiagnosticContentCvr2;
    }

    public String getSampleCntCtr() {
        return sampleCntCtr;
    }

    public void setSampleCntCtr(String sampleCntCtr) {
        this.sampleCntCtr = sampleCntCtr;
    }

    public String getCtrSamples() {
        return ctrSamples;
    }

    public void setCtrSamples(String ctrSamples) {
        this.ctrSamples = ctrSamples;
    }

    public String getSampleCntCvr() {
        return sampleCntCvr;
    }

    public void setSampleCntCvr(String sampleCntCvr) {
        this.sampleCntCvr = sampleCntCvr;
    }

    public String getCvrSamples() {
        return cvrSamples;
    }

    public void setCvrSamples(String cvrSamples) {
        this.cvrSamples = cvrSamples;
    }

    public String getTopMa2T() {
        return topMa2T;
    }

    public void setTopMa2T(String topMa2T) {
        this.topMa2T = topMa2T;
    }

    public String getSumLaunchCntMa2() {
        return sumLaunchCntMa2;
    }

    public void setSumLaunchCntMa2(String sumLaunchCntMa2) {
        this.sumLaunchCntMa2 = sumLaunchCntMa2;
    }

    public String getCtrMostMa2() {
        return ctrMostMa2;
    }

    public void setCtrMostMa2(String ctrMostMa2) {
        this.ctrMostMa2 = ctrMostMa2;
    }

    public String getTopMa2V() {
        return topMa2V;
    }

    public void setTopMa2V(String topMa2V) {
        this.topMa2V = topMa2V;
    }

    public String getCvrMostMa2() {
        return cvrMostMa2;
    }

    public void setCvrMostMa2(String cvrMostMa2) {
        this.cvrMostMa2 = cvrMostMa2;
    }
}