package cn.com.duiba.tuia.core.api.enums.adx;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName: AdxAdvertCheckStatusEnum <br/>
 * Function: adx广告审核状态枚举. <br/>
 * date: 20202年04月03日 下午7:11:05 <br/>
 *
 * @author lijian
 */
public enum AdxAdvertCheckStatusEnum {

    AUDIT_ING(0, "审核中"),

    AUDIT_PASS(1, "审核通过"),

    AUDIT_REJECT(2, "审核拒绝");

    private Integer code;
    private String desc;

    AdxAdvertCheckStatusEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AdxAdvertCheckStatusEnum> enumMap = Maps.newHashMap();

    static {
        for (AdxAdvertCheckStatusEnum it : AdxAdvertCheckStatusEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdxAdvertCheckStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
