package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 新赔付列表的广告计划是否为新计划枚举
 *
 * @author zhangbaiqiang
 * @date 2021/4/27
 */
@Getter
@AllArgsConstructor
public enum ExceedEnum {

    NO(0, "否"),
    YES(1, "是");

    private final Integer type;
    private final String  desc;

    public static String getDesc(Integer type) {
        return Objects.equals(type, YES.type) ? YES.desc : NO.desc;
    }
}
