package cn.com.duiba.tuia.core.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/7/6
 * @Description
 * @Param
 * @return
 **/
@Data
public class AdvertLinkAuditDTO extends BaseDto {
    /**
     * 广告位ID
     */
    private Long slotId;
    /**
     * 主键id列表
     */
    private List<Long> ids;
    /**
     * 广告位ID列表
     */
    private List<Long> slotIds;
    /**
     * 广告ID
     */
    private Long advertId;
    /**
     * 广告ID列表
     */
    private List<Long> advertIdList;
    /**
     * 广告id列表字符串
     */
    private String advertIds;
    /**
     * 广告名称
     */
    private String advertName;
    /**
     * 行业标签id
     */
    private String industryLabel;
    /**
     * 行业标签列表
     */
    private List<String> industryLabels;
    /**
     * 行业标签名称
     */
    private String industryLabelName;
    /**
     * 资源标签id
     */
    private String resourceLabel;
    /**
     * 资源标签id列表
     */
    private List<String> resourceLabels;
    /**
     * 资源标签名称
     */
    private String resourceLabelName;
    /**
     * 落地页标签，多个用","分隔
     */
    private String landPageLabel;
    /**
     * 审核类型 1:落地页审核;2:素材审核
     * @see  cn.com.duiba.tuia.core.api.enums.AuditStatusEnum
     */
    private Integer auditType;
    /**
     * 链接类型 1:广告推广链接;2:定向配置链接;3:测试链接
     * @see cn.com.duiba.tuia.core.api.enums.LinkTypeEnum
     */
    private Integer linkType;
    /**
     * 链接类型列表
     */
    private List<Integer> linkTypeList;
    /**
     * 审核资源ID 入落地页id
     */
    private Long auditResourceId;
    /**
     * 审核链接
     */
    private String auditLink;
    /**
     * 审核状态 1:审核中;2:审核通过;3:审核拒绝
     * @see cn.com.duiba.tuia.core.api.enums.AuditStatusEnum
     */
    private Integer auditStatus;
    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date operateTime;
    /**
     * 操作审核时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date triggerAuditTime;
    /**
     * 触发审核开始时间
     */
    private Date triggerAuditStartTime;
    /**
     * 触发审核时间结束时间
     */
    private Date triggerAuditEndTime;
    /**
     * 删除标志
     */
    private Integer isDeleted;
    /**
     * 起始记录
     */
    private Integer rowStart;

    /** 当前页. */
    private Integer currentPage;

    /** 每页记录数， 为-1时代表查询所有. */
    private Integer pageSize;

    //数据来源id 比如积木那边创建的落地页id   必填
    private  Long  sourceId;

    //平台系统 1积木 2百奇    必填
    private Integer sourceType;
}
