package cn.com.duiba.tuia.core.api.dto.advert;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel
public class TagNewTradeDto extends BaseDto {

    private static final long serialVersionUID = -2915122660382377739L;

    @ApiModelProperty(value = "行业标签(也有可能是落地页标签)")
    private String tagNum;

    @ApiModelProperty(value = "综合行业名称(新行业)")
    private String newTrade;

    @ApiModelProperty(value = "新行业ID（与new_trade一致）")
    private Integer tradeTagId;

    @ApiModelProperty(value = "是否删除,1-已删除;0-未删除。默认 0.")
    private Integer isDeleted;

    @ApiModelProperty(value = "新行业关联标签列表")
    private List<TagNewTradeDto> childList;

    public String getTagNum() {
        return tagNum;
    }

    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    public String getNewTrade() {
        return newTrade;
    }

    public void setNewTrade(String newTrade) {
        this.newTrade = newTrade;
    }

    public Integer getTradeTagId() {
        return tradeTagId;
    }

    public void setTradeTagId(Integer tradeTagId) {
        this.tradeTagId = tradeTagId;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public List<TagNewTradeDto> getChildList() {
        return childList;
    }

    public void setChildList(List<TagNewTradeDto> childList) {
        this.childList = childList;
    }
}