package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertPlanReginDTO;
import cn.com.duiba.tuia.core.api.param.AdvertPlanRegionQueryParam;
import cn.com.duiba.tuia.core.api.param.AdvertPlanRegionUpdateParam;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2024/11/25
 * @Description
 **/
@AdvancedFeignClient
public interface RemoteAdvertPlanRegionService {
    /**
     * 查询推广计划对应的地域信息
     * 这里查询的是推广计划下类型为互动的广告id 下的默认配置的地域配置
     * @param param
     * @return
     */
    List<AdvertPlanReginDTO> queryRegion(AdvertPlanRegionQueryParam param);

    /**
     * 更新 或者 覆盖 或者删除推广计划对应的地域信息
     * 这里操作的也是推广计划下类型为互动的广告id 下的默认配置的地域配置
     * @param param
     * @return
     */
    Boolean updateRegion(AdvertPlanRegionUpdateParam param);

}
