package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.TypeSpecialPackageParam;
import cn.com.duiba.tuia.core.api.dto.account.rsp.TypeSpecialPackageDto;

import java.util.List;

/**
 * Created by lijian on 2019/8/28 14:07
 * description:
 *
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteTypeSpecialPackageService {
    /**
     * 新增广告主类型或广告主类型对应流量包
     *
     * @param dto
     * @return
     */
    Integer insert(TypeSpecialPackageDto dto);

    /**
     * 批量新增广告主类型对应流量包
     *
     * @param list
     * @return
     */
    Integer batchInsert(List<TypeSpecialPackageDto> list);

    /**
     * 更新广告主类型或广告主类型对应流量包
     *
     * @param dto
     * @return
     */
    Integer updateById(TypeSpecialPackageDto dto);

    /**
     * 删除广告主类型或广告主类型对应流量包
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据广告主类型id列表查询广告主类型或广告主类型对应流量包
     *
     * @param parentIds
     * @return
     */
    List<TypeSpecialPackageDto> selectByParentIds(List<Long> parentIds);

    /**
     * 查询所有广告主类型对应的特殊流量包
     *
     * @return
     */
    List<TypeSpecialPackageDto> querySpecialPackage();

    /**
     * 根据条件查询数据的数量
     *
     * @param param
     * @return
     */
    Integer getCountByParam(TypeSpecialPackageParam param);
}
