package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.advert.SimilarAdInfoDto;

import java.util.List;


/**
 * 相似广告远程服务
 */
@AdvancedFeignClient
public interface RemoteSimilarAdService {


    /**
     * 查询单个广告信息
     * @param advertId
     * @return
     */
    SimilarAdInfoDto querySimilarAdInfo(Long advertId);

    /**
     * 查询相似广告
     * @param advertId
     * @return
     */
    List<SimilarAdInfoDto> querySimilarAds(Long advertId);


    /**
     * 添加相似广告
     * @param req
     * @return
     */
    Boolean addSimilarAds(Long advertId,List<SimilarAdInfoDto> req);
}
