
package cn.com.duiba.tuia.core.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * adx广告素材表
 *
 * @author: lijian
 * @version:
 */
@ApiModel
public class AdxAdvertMaterialDto extends BaseDto {

    private static final long serialVersionUID = 1427793307190399468L;

    @ApiModelProperty("DSP平台标识")
    private Long dspId;

    @ApiModelProperty("adx广告id")
    private Long advertId;

    @ApiModelProperty("广告类型,1-互动广告、2-展示广告、3-激励广告")
    private Integer advertType;

    @ApiModelProperty("推广链接url")
    private String promoteUrl;

    @ApiModelProperty("DSP平台名称")
    private String dspName;

    @ApiModelProperty("素材的图片地址")
    private String imgUrl;

    @ApiModelProperty("按钮文案")
    private String buttonText;

    @ApiModelProperty("优惠券名称")
    private String couponName;

    @ApiModelProperty("审核状态,0-审核中;1-审核通过;2-审核拒绝")
    private Integer checkStatus;

    @ApiModelProperty("行业标签,以英文逗号隔开")
    private String industryTag;

    @ApiModelProperty("落地页标签,以英文逗号隔开")
    private String promoteTag;

    @ApiModelProperty("素材标签,以英文逗号隔开")
    private String materialTag;

    @ApiModelProperty("属性标签,以英文逗号隔开")
    private String bannedTag;

    @ApiModelProperty("删除状态(0：未删除， 1：已删除")
    private Integer isDeleted;

    //原因
    private String reason;
    //审核记录数量
    private Integer recordCount;

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getDspName() {
        return dspName;
    }

    public void setDspName(String dspName) {
        this.dspName = dspName;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getIndustryTag() {
        return industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public String getPromoteTag() {
        return promoteTag;
    }

    public void setPromoteTag(String promoteTag) {
        this.promoteTag = promoteTag;
    }

    public String getMaterialTag() {
        return materialTag;
    }

    public void setMaterialTag(String materialTag) {
        this.materialTag = materialTag;
    }

    public String getBannedTag() {
        return bannedTag;
    }

    public void setBannedTag(String bannedTag) {
        this.bannedTag = bannedTag;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public void setRecordCount(Integer recordCount) {
        this.recordCount = recordCount;
    }

}
