package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.rsp.AppSlotInfo;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/3/9
 * @function
 */
public class ExportAppPackageDetailDto implements Serializable {

    private static final long serialVersionUID = 5607071845545369396L;

    //导出预览
    public static final Integer VIEW_EXPORT = 0;

    //导出生成流量包
    public static final Integer DO_EXPORT = 1;

    //更新导出
    public static final Integer UPDATE_EXPORT = 2;

    /**
     * 是否导出成功
     */
    private Boolean isSuccess;

    /**
     * 流量包下媒体数量
     */
    private Integer totalAppCount;

    /**
     * 定向媒体数量
     */
    private Integer targetAppCount;

    /**
     * 限流媒体的数量
     */
    private Integer limitAppCount;

    /**
     * 新增媒体数
     */
    private Integer addAppCount;

    /**
     * 移除媒体数
     */
    private Integer removeAppCount;

    /**
     * 更新失败原因
     */
    private String failReason;

    /**
     *计算后的结果
     */
    private List<AppSlotInfo> appSlotInfoList;

    public ExportAppPackageDetailDto() {
    }

    public ExportAppPackageDetailDto(Boolean isSuccess, String failReason) {
        this.isSuccess = isSuccess;
        this.failReason = failReason;
    }

    public ExportAppPackageDetailDto(Boolean isSuccess, Integer totalAppCount, Integer targetAppCount, Integer limitAppCount, List<AppSlotInfo> appSlotInfoList) {
        this.isSuccess = isSuccess;
        this.totalAppCount = totalAppCount;
        this.targetAppCount = targetAppCount;
        this.limitAppCount = limitAppCount;
        this.appSlotInfoList = appSlotInfoList;
    }



    public Integer getTotalAppCount() {
        return totalAppCount;
    }

    public void setTotalAppCount(Integer totalAppCount) {
        this.totalAppCount = totalAppCount;
    }

    public Integer getTargetAppCount() {
        return targetAppCount;
    }

    public void setTargetAppCount(Integer targetAppCount) {
        this.targetAppCount = targetAppCount;
    }

    public Integer getLimitAppCount() {
        return limitAppCount;
    }

    public void setLimitAppCount(Integer limitAppCount) {
        this.limitAppCount = limitAppCount;
    }

    public List<AppSlotInfo> getAppSlotInfoList() {
        return appSlotInfoList;
    }

    public void setAppSlotInfoList(List<AppSlotInfo> appSlotInfoList) {
        this.appSlotInfoList = appSlotInfoList;
    }

    public Boolean getSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public Integer getAddAppCount() {
        return addAppCount;
    }

    public void setAddAppCount(Integer addAppCount) {
        this.addAppCount = addAppCount;
    }

    public Integer getRemoveAppCount() {
        return removeAppCount;
    }

    public void setRemoveAppCount(Integer removeAppCount) {
        this.removeAppCount = removeAppCount;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
