package cn.com.duiba.tuia.core.api.dto.backflowManualRecord;

import cn.com.duiba.tuia.core.api.statistics.domain.ByDateQueryReq;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lijicong
 * @since 2022-04-18
 */
@Getter
@Setter
public class BackflowManualRecordQueryDTO  extends ByDateQueryReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID")
    protected Long id;

    @ApiModelProperty(value = "广告id")
    private Long advertId;

    @ApiModelProperty(value = "广告名称")
    private String advertName;

    @ApiModelProperty(value = "广告主id")
    private Long advertiserId;

    @ApiModelProperty(value = "广告主名称")
    private String advertiserName;

    @ApiModelProperty(value = "配置id")
    private Long orientPackageId;

    @ApiModelProperty(value = "配置名称")
    private String orientPackageName;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "媒体名称")
    private String appName;

    @ApiModelProperty(value = "广告位id")
    private String slotId;

    @ApiModelProperty(value = "广告位名称")
    private String slotName;

    @ApiModelProperty(value = "消耗")
    private BigDecimal consumeAmount;

    @ApiModelProperty(value = "回流时间")
    private Date reflowDate;

    @ApiModelProperty(value = "回流模式  1.点击模式 2.转化模式")
    private Integer reflowType;

    @ApiModelProperty(value = "回流状态  1.回流中 2.回流完成")
    private Integer reflowStatus;

    @ApiModelProperty(value = "曝光pv")
    private Long exposurePv;

    @ApiModelProperty(value = "点击pv")
    private Long clickPv;

    @ApiModelProperty(value = "点击率")
    private BigDecimal ctr;

    @ApiModelProperty(value = "转化pv")
    private Long converPv;

    @ApiModelProperty(value = "创建人名称")
    private String creator;

    @ApiModelProperty(value = "消耗主体类型")
    private Integer effectiveMainType;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("是否是自动回流创建的任务 1-自动 0-手动")
    private Integer isAuto;

}
