package cn.com.duiba.tuia.core.api.dto.req.advert.material;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: AuditAdvertMaterialDto <br/>
 * Function: 素材审核请求dto. <br/>
 * date: 2017年11月17日 上午11:22:19 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AuditAdvertMaterialDto implements Serializable {

    private static final long serialVersionUID = -4207247783618417671L;

    /** 审核类型：0-拒绝；3-通过 */
    private Integer           audiType;

    /** 素材Id */
    private Long              id;

    /** 拒绝理由 */
    private String            reason;

    /** 素材标签 */
    private List<String>      materialTagNums;

    /** 属性标签 */
    private List<String> advertBannedTagNums;

    /** 审核来源：0-兑吧；1-推啊 */
    private Integer           sourceAudit;

    private String auditor;

    /**
     * 审核人
     */
    private String reviewer;

    // 材料类型：0-素材，1-弹层
    private Integer type;


    /**
     * MaterialCheckRecordDto.
     *    public final static Integer ADVERTCHECK=1;
     *     public   final static Integer RISKCHECK=2;
     *      1.广告系统审核2.钟馗跳转广告系统复审
     * @author fanjia
     * @date 2021/11/1 上午11:13

     */
    private Integer checkType;

    /**
     * 如果是钟馗跳转过来的审核 ,那条审核记录的id
     */
    private Long riskSourceId;

    /**
     * 审核可以看见的落地页列表
     */
    private String seeSourceMateriaIds;

    /**
     * 审核可以看见的素材列表
     */
    private String seeSourcePromoteIds;

    /**需要关联的落地页id*/
    private String promoteIds;
    /**
     *落地页审核接口-新增的字段。广告审核的通过的时候 就需要传这个字段 素材类型   区分adx 和普通素材
     */
    private Integer advertMaterialType;


    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public Long getRiskSourceId() {
        return riskSourceId;
    }

    public void setRiskSourceId(Long riskSourceId) {
        this.riskSourceId = riskSourceId;
    }

    public String getSeeSourceMateriaIds() {
        return seeSourceMateriaIds;
    }

    public void setSeeSourceMateriaIds(String seeSourceMateriaIds) {
        this.seeSourceMateriaIds = seeSourceMateriaIds;
    }

    public String getSeeSourcePromoteIds() {
        return seeSourcePromoteIds;
    }

    public void setSeeSourcePromoteIds(String seeSourcePromoteIds) {
        this.seeSourcePromoteIds = seeSourcePromoteIds;
    }

    public String getPromoteIds() {
        return promoteIds;
    }

    public void setPromoteIds(String promoteIds) {
        this.promoteIds = promoteIds;
    }

    public Integer getAdvertMaterialType() {
        return advertMaterialType;
    }

    public void setAdvertMaterialType(Integer advertMaterialType) {
        this.advertMaterialType = advertMaterialType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * audiType.
     *
     * @return the audiType
     * @since JDK 1.8
     */
    public Integer getAudiType() {
        return audiType;
    }

    /**
     * audiType.
     *
     * @param audiType the audiType to set
     * @since JDK 1.8
     */
    public void setAudiType(Integer audiType) {
        this.audiType = audiType;
    }

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.8
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.8
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * reason.
     *
     * @return the reason
     * @since JDK 1.8
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     * @since JDK 1.8
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * materialTagNums.
     *
     * @return the materialTagNums
     * @since JDK 1.8
     */
    public List<String> getMaterialTagNums() {
        return materialTagNums;
    }

    /**
     * materialTagNums.
     *
     * @param materialTagNums the materialTagNums to set
     * @since JDK 1.8
     */
    public void setMaterialTagNums(List<String> materialTagNums) {
        this.materialTagNums = materialTagNums;
    }

    /**
     * sourceAudit.
     *
     * @return the sourceAudit
     * @since JDK 1.8
     */
    public Integer getSourceAudit() {
        return sourceAudit;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    /**
     * sourceAudit.
     *
     * @param sourceAudit the sourceAudit to set
     * @since JDK 1.8
     */
    public void setSourceAudit(Integer sourceAudit) {
        this.sourceAudit = sourceAudit;
    }

    public List<String> getAdvertBannedTagNums() {
        return advertBannedTagNums;
    }

    public void setAdvertBannedTagNums(List<String> advertBannedTagNums) {
        this.advertBannedTagNums = advertBannedTagNums;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }
}
