package cn.com.duiba.tuia.core.api.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2024/11/25
 * @Description
 **/
@Data
public class AdvertPlanRegionUpdateParam implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 广告主id
     */
    @NotNull(message = "广告主id不能为空")
    private Long advertiserId;
    /**
     * 推广计划id
     */
    @NotNull(message = "推广计划不能为空")
    private List<Long> advertPlanIds;
    /**
     * 广告主密钥
     */
    @NotBlank(message = "广告主密钥不能为空")
    private String advertKey;
    /**
     * 修改类型：1.覆盖 2.新增 3.删除
     */
    @NotNull(message = "修改类型不能为空")
    private Integer updateType;

    private String region;

}
