package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertLinkAuditCountDTO;
import cn.com.duiba.tuia.core.api.dto.AdvertLinkAuditDTO;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.param.AdvertLinkDataParam;
import cn.com.duiba.tuia.core.api.param.UpdateAdvertLinkAuditParam;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2021/7/7
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteAdvertLinkAuditService {

    /**
     * 分页查询
     * @param advertLinkAuditDTO 查询参数
     * @return PageDto<AdvertLinkAuditDTO>
     * @throws BizException
     */
    PageDto<AdvertLinkAuditDTO> queryByPage(AdvertLinkAuditDTO advertLinkAuditDTO) throws BizException;

    /**
     * 通过条件查询
     * @param advertLinkAuditDTO 查询参数
     * @return List<AdvertLinkAuditDTO>
     * @throws BizException
     */
    List<AdvertLinkAuditDTO> queryByCondition(AdvertLinkAuditDTO advertLinkAuditDTO) throws BizException;

    /**
     * 批量审核
     * @param slotId 广告位id
     * @param recordIds 审核记录id
     * @param auditStatus 审核状态
     * @param adminId 审核人id
     * @return
     * @throws BizException
     */
    void batchAudit(Long slotId, List<Long> recordIds, Integer auditStatus, Long adminId) throws BizException;

    /**
     * 根据slot分组查询审核记录数量
     * @param slotIds 广告位id列表
     * @return
     * @throws BizException
     */
    List<AdvertLinkAuditCountDTO> queryWaitApproveCountBySlotIds(List<Long> slotIds) throws BizException;


    /**
     * 根据条件查询所有审核通过的广告url信息
     * @param param
     * @return
     */
    List<AdvertLinkAuditDTO> getValidAdvertUrls(AdvertLinkDataParam param);

    /**
     * 当广告位落地页链接审核开启以及更新可投列表映射关系时调用 --用于更新审核记录
     * @param slotIds 广告位id列表
     * @param adminId 操作人
     * @throws BizException
     *
     */
    void initWhenOpenIsLandPageAudit(List<Long> slotIds, Long adminId) throws BizException;

    /**
     * 当广告位落地页链接审核关闭时使用 --用于删除审核记录
     * @param slotIds 广告位id
     * @param adminId 操作人
     * @throws BizException
     */
    void updateWhenCloseIsLandPageAudit(List<Long> slotIds, Long adminId) throws BizException;

    /**
     * 当落地页链接修改后使用 --更新广告位和落地页审核链接的关系
     * @param param 修改的落地页链接信息
     */
    void updateWhenAdvertLinkChange(UpdateAdvertLinkAuditParam param);

    /**
     * 当媒体管理后台 屏蔽标签改变时重新拉取对应关系重新初始化
     * @param slotId
     * @throws BizException
     */
    void updateWhenLabelScreenRulesChange(Long slotId) throws BizException;

}
