package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.PackageWhiteDto;
import cn.com.duiba.tuia.core.api.dto.advert.PackageWhiteListDto;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteWhiteListService
 * @projectName tuia-advert-center
 * @description: description
 * @date 2024.11.14 19:53
 */
@AdvancedFeignClient
public interface RemoteWhiteListService {

    /**
     * 获取 广告配置信息
     *
     * @param slotId
     * @param appId
     * @param strategyId
     * @return
     */
    PackageWhiteDto getPackageWhiteInfo(Long slotId, Long appId, Long strategyId, String strategyType);

    /**
     * 获取 广告配置信息 更新
     */
    Boolean updatePackageWhiteInfo(Long slotId, Long appId, Long strategyId, Integer packageFlag);


    /**
     * 获取 广告配置白名单列表
     *
     * @param slotId
     * @param appId
     * @param strategyId
     * @return
     */
    List<PackageWhiteListDto> getPackageWhiteList(Long slotId, Long appId, Long strategyId);

    /**
     * 广告配置白名单 绑定
     */
    Boolean bindPackage(Long slotId, Long appId, Long strategyId, String strategyType, List<Long> packageIds);

    /**
     * 广告配置白名单 解绑
     */
    Boolean removePackage(Long slotId, Long appId, Long strategyId, String strategyType, Long packageId);
}
