package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.AdvertiserSecretKeyDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqAdvertiserSecretKeyDto;

import java.util.List;

/**
 * 广告主秘钥远程服务接口
 * @Author chensong
 * @Create 2019-01-23
 */
@AdvancedFeignClient
public interface RemoteAdvertiserSecretKeyService {

    /**
     * 根据id查询
     * @param advertiserId
     * @return
     */
    AdvertiserSecretKeyDto selectByAdvertiserId(Long advertiserId);

    /**
     * 插入数据
     * @param advertiserSecretKey
     * @return
     */
    int insertAdvertiserSecretKey(AdvertiserSecretKeyDto advertiserSecretKey);

    /**
     * 分页查询
     *
     * @param req
     * @return
     */
    PageDto<AdvertiserSecretKeyDto> pageQuery(ReqAdvertiserSecretKeyDto req);

    /**
     * 根据广告主秘钥查询同组内的所有广告主秘钥
     * 返回结果已经对传入秘钥参数去重
     * 当广告主秘钥不存在时或不存在秘钥组或组内无其它广告主秘钥时返回 empty list
     *
     * @param secretKey
     * @return
     */
    List<String> selectGroupSecretKey(String secretKey);

    /**
     * 根据广告主秘钥查询
     * @param secretKey
     * @return
     */
    AdvertiserSecretKeyDto selectBySecretKey(String secretKey);
}
