/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertAppOfflineDayService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.appOffline
 * Date:2017年12月14日下午3:36:42
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.appOffline;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.appOffline.ReqAdvertAppOfflineHourDto;
import cn.com.duiba.tuia.core.api.dto.rsp.appOffline.RspAdvertAppOfflineHourDto;

/**
 * ClassName:RemoteAdvertAppOfflineDayService <br/>
 * Function: 实时每小时广告媒体下线接口. <br/>
 * Date:     2017年12月14日 下午3:36:42 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAdvertAppOfflineHourService {
    /**
     * 
     * selectAdvertAppShieldHour:(查询实时每小时媒体下线-广告). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<RspAdvertAppOfflineHourDto> selectAdvertAppOfflineHour(ReqAdvertAppOfflineHourDto query);

    /**
     * 获取媒体状态
     * @param appIds
     * @return
     */
    Map<Long,Integer> queryAppStatus(List<Long> appIds);
}

