package cn.com.duiba.tuia.core.api.remoteservice.promotetest;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.abtest.PromoteTestMessageInfoDTO;

/**
 * @author fanjia
 * @date 2021年07月09日 上午11:40
 */
@AdvancedFeignClient
public interface ReomtePromoteTestMessageInfoService {


    /**
     * 根据广告id+消息类型 改变消息的状态
     *
     * @param advertId
     * @param messageType  cn.com.duiba.tuia.core.api.enums.PromoteTestMessageEnmu
     * @param messageState 0未读 1已读
     * @return int
     * @author fanjia
     * @date 2021/7/9 上午11:51
     */
    public int updateMessageState(Long advertId, Integer messageType, Integer messageState);


    /**
     * @param promoteTestMessageInfoDTO
     * @return int
     * @author fanjia
     * @date 2021/7/9 下午2:01
     */
    public int insertPromoteTestMessageInfo(PromoteTestMessageInfoDTO promoteTestMessageInfoDTO);


    /**
     *   查询未读消息数量
     * @author fanjia
     * @date 2021/7/9 下午2:07
     * @param advertId
     * @param messageType
     * @return int
     */
    public int countUnReadMessage(Long advertId, Integer messageType);


}
