package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**dws_advert_item_agent_day 广告每日统计数据-广告,商品,代理商 表的rpc
 * @author fanjia
 * @date 2021年08月20日 下午2:37
 */
@AdvancedFeignClient
public interface RemoteDwAdvertStatisticsDayService {

    /**
     * 根据开始时间-结束时间这个范围. 查询出 代理商旗下广告主累计消费>=ConsumeTotal的代理商
     * 例如
     * starDate=2021-08-05 endDate=2021-08-20 consumeTotal=1000000
     * 代表查询5-20号这15天日期里 代理商旗下的广告主累计15天消费>=1000块钱的 代理商id
     * @author fanjia
     * @date 2021/8/20 下午2:18
     * @param starDate  开始日期 2021-08-05
     * @param endDate    结束日期 2021-08-20
     * @param consumeTotal   累计需要>的消耗金额(分)
     * @return java.lang.Long
     */
    List<Long> getAgentIdConsumeTotalRangeByDate(String starDate, String endDate, Long consumeTotal);

    /**
     * 根据开始时间-结束时间这个范围. 查询出 广告主累计消费>=ConsumeTotal 广告主id集合
     * 例如
     * starDate=2021-08-05 endDate=2021-08-20 consumeTotal=1000000
     * 代表查询5-20号这15天日期里 广告主累计15天消费>=1000块钱的 广告主id集合
     * @author fanjia
     * @date 2021/8/20 下午2:18
     * @param starDate  开始日期 2021-08-05
     * @param endDate    结束日期 2021-08-20
     * @param consumeTotal   累计需要>的消耗金额(分)
     * @return java.lang.Long
     */
    List<Long> getAdvertiserIdConsumeTotalRangeByDate(String starDate, String endDate, Long consumeTotal);
}
