package cn.com.duiba.tuia.core.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.NewTagDto;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.TagLibraryRelationLevelDto;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.TagLibraryRelationSaveOrUpdateReq;

import java.util.List;

/**
 * 标签映射管理-三级标签之间的父子关系 rpc
 */

@AdvancedFeignClient
public interface RemoteTagLibraryRelationService {

    /**
     * 查询可以当成父标签的标签
     *
     * @param tagNumType
     * 04.03 (落地页的的包装形式)
     *
     * 05.02(素材的包装形式)
     * @return
     */
    List<NewTagDto> canParentList(String tagNumType) throws BizException;



    /**
     * 查询可以当成子标签的标签
     *
     * @param tagNumType tag_library_new表里的 tag_num 04开头代表落地页标签 05开头代表 素材标签
     * 标签类型  代码里会拼上0
     * 04.03 (落地页的的包装形式)
     *
     * 05.02(素材的包装形式)
     * @param parentTagNum 父标签
     * @return
     */
    List<NewTagDto> canChildList(String tagNumType,String parentTagNum) throws BizException;


    /**
     *  映射关系父子标签存储/更新
     * @param tagLibraryRelationSaveOrUpdateReq
     * @return
     */
    Integer saveOrUpdate(TagLibraryRelationSaveOrUpdateReq tagLibraryRelationSaveOrUpdateReq) throws BizException;



    /**
     *  删除
     * @return
     */
    Integer deleted(Long id) throws BizException;


    /**
     * 查询所有标签的父子级关系
     * @return
     */
    List<TagLibraryRelationLevelDto> selectAllTagLibraryRelationLevelList();





}
