package cn.com.duiba.tuia.core.api.remoteservice.wechatwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatLinkDTO;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatLinkPageDTO;
import cn.com.duiba.tuia.core.api.dto.wechatwork.WechatLinkSaveDTO;

@AdvancedFeignClient
public interface RemoteWechatLinkService {

    /**
     * 新建获客链接
     *
     * @param saveDTO
     * @return
     */
    int save(WechatLinkSaveDTO saveDTO);

    /**
     * 分页查询获客链接
     *
     * @param pageDTO
     * @return
     */
    PageDto<WechatLinkDTO> page(WechatLinkPageDTO pageDTO);

    /**
     * 启用获客链接
     *
     * @param id
     * @return
     */
    int enable(Long id);

    /**
     * 禁用获客链接
     *
     * @param id
     * @return
     */
    int disable(Long id);
}
