/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.common.GoogleAuthenticator;

import java.util.ArrayList;
import java.util.List;

public final class GoogleAuthenticatorKey {
    private static final String QR_FORMAT = "https://www.google.com/chart?chs=200x200&chld=M%%7C0&cht=qr&chl=otpauth://totp/%s@%s%%3Fsecret%%3D%s";
    private final String key;
    private final int verificationCode;
    private final List<Integer> scratchCodes;

    GoogleAuthenticatorKey(String secretKey, int code, List<Integer> scratchCodes) {
        this.key = secretKey;
        this.verificationCode = code;
        this.scratchCodes = new ArrayList<Integer>(scratchCodes);
    }

    public static String getQRBarcodeURL(String user, String host, String secret) {
        return String.format(QR_FORMAT, user, host, secret);
    }

    public List<Integer> getScratchCodes() {
        return this.scratchCodes;
    }

    public String getKey() {
        return this.key;
    }

    public int getVerificationCode() {
        return this.verificationCode;
    }
}

