/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(String str) {
        if (str == null) throw new IllegalArgumentException("Cannot zip null or empty string");
        if (str.length() == 0) {
            throw new IllegalArgumentException("Cannot zip null or empty string");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(str.getBytes(StandardCharsets.UTF_8));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to zip content", e);
        }
    }
}

