/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.util;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Splitter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HbaseUtil {
    private static final String joiner = "-";

    public static String buildRowKey(Long advertId, Long appId, Integer type) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(type);
        String today = String.valueOf(DateUtils.getDayNumber((Date)new Date()));
        rowkeyBuffer.append(joiner).append(today).append(joiner);
        if (appId != null) {
            rowkeyBuffer.append(String.valueOf(appId));
        }
        return rowkeyBuffer.toString();
    }

    public static String buildRowKey(Long advertId, Long appId, Integer type, Date date) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(type);
        String today = String.valueOf(DateUtils.getDayNumber((Date)date));
        rowkeyBuffer.append(joiner).append(today).append(joiner);
        if (appId != null) {
            rowkeyBuffer.append(String.valueOf(appId));
        }
        return rowkeyBuffer.toString();
    }

    public static String buildHourRowKey(Long advertId, Long appId, String curDate, String curHour) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(appId);
        String today = String.valueOf(DateUtils.getDayNumber((Date)DateUtils.getDayDate((String)curDate)));
        rowkeyBuffer.append(joiner).append(today).append(joiner).append(curHour);
        return rowkeyBuffer.toString();
    }

    public static String buildRowKey(Long advertId) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        String today = String.valueOf(DateUtils.getDayNumber((Date)new Date()));
        rowkeyBuffer.append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    public static String buildRowKey(Long advertId, Date date) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        String today = String.valueOf(DateUtils.getDayNumber((Date)date));
        rowkeyBuffer.append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    public static String buildSlotRowKey(Long advertId, Long slotId) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        String today = String.valueOf(DateUtils.getDayNumber((Date)new Date()));
        rowkeyBuffer.append(joiner).append(slotId).append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    public static String buildEveryMinuteRowKey(Long advertId, Long appId, String dateTime) {
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        if (appId != null) {
            rowkeyBuffer.append(joiner).append(String.valueOf(appId));
        }
        rowkeyBuffer.append(joiner).append(dateTime);
        return rowkeyBuffer.toString();
    }

    public static Long getAppIdByEveryMinuteRowKey(String rowKey) {
        List stringList = Splitter.on((String)joiner).splitToList((CharSequence)rowKey);
        String appId = (String)stringList.get(1);
        return Long.parseLong(appId);
    }

    public static Long getAppIdByRowKey(String rowKey) {
        List stringList = Splitter.on((String)joiner).splitToList((CharSequence)rowKey);
        String activityTypeStr = (String)stringList.get(1);
        Integer activityType = -1;
        if (StringUtils.isNotBlank((String)activityTypeStr)) {
            activityType = Integer.parseInt(activityTypeStr);
        }
        int index = activityType == -1 ? 4 : 3;
        String appId = (String)stringList.get(index);
        return Long.parseLong(appId);
    }

    public static Long getSlotIdByRowKey(String rowKey) {
        List stringList = Splitter.on((String)joiner).splitToList((CharSequence)rowKey);
        String slotId = (String)stringList.get(1);
        return Long.parseLong(slotId);
    }

    public static String getCurHourByRowKey(String rowKey) {
        List stringList = Splitter.on((String)joiner).splitToList((CharSequence)rowKey);
        String curHour = (String)stringList.get(stringList.size() - 1);
        return curHour;
    }

    public static Long getAdvertIdByRowKey(String rowKey) {
        List stringList = Splitter.on((String)joiner).splitToList((CharSequence)rowKey);
        String advertId = new StringBuffer((String)stringList.get(0)).reverse().toString();
        return Long.parseLong(advertId);
    }
}

