package cn.com.duiba.tuia.core.util;

import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

import org.apache.commons.lang.StringUtils;

/**
 * 发券订单存储hbase的rowkey工具
 *
 * @author peanut.huang
 * @date 2019/5/5
 * @since JDK 1.8
 */
public class OrderRowKeyUtils {

    /**
     * Used to build output as Hex
     */
    private static final char[] DIGITS_LOWER = {
        '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
    };

    /**
     * 生成rowkey
     *
     * @param key
     * @return
     */
    public static String genRowKey(String key){
        if(StringUtils.isBlank(key)){
            throw new IllegalArgumentException("生成rowkey错误: key为空");
        }

        return computeMD5(key).substring(0, 4) + "-" + key;
    }

    /**
     * 字段转换md5
     *
     * @param input
     * @return
     */
    private static String computeMD5(String input) {
        if (input == null) {
            return "";
        }
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(input.getBytes("UTF-8"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] digestBytes = digest.digest();

        return new String(encodeHex(digestBytes));

    }

    /**
     *
     * @param stream
     * @return
     */
    public static String computeMD5(InputStream stream) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");

            DigestInputStream digestStream = new DigestInputStream(stream, digest);
            while (digestStream.read() != -1) {
                ; //digest is updating
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] digestBytes = digest.digest();

        return new String(encodeHex(digestBytes));
    }

    /**
     * Converts an array of bytes into an array of characters representing the hexadecimal values of each byte in order.
     * The returned array will be double the length of the passed array, as it takes two characters to represent any
     * given byte.
     *
     * @param data
     *            a byte[] to convert to Hex characters
     * @return A char[] containing hexadecimal characters
     */
    private static char[] encodeHex(byte[] data) {

        int l = data.length;

        char[] out = new char[l << 1];

        // two characters form the hex value.
        for (int i = 0, j = 0; i < l; i++) {
            out[j++] = DIGITS_LOWER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0x0F & data[i]];
        }

        return out;
    }


}
