/**
 * 
 */
package cn.com.duiba.tuia.core.common;

/**
 * 此类描述的是： 推啊core工程内部自定义错误码规范<br>
 * 错误码组成：AABCCC
 * <ul>
 * AA：模块编号
 * <li>00：公用模块</li>
 * <li>01：用户模块</li>
 * <li>02：广告模块</li>
 * <li>03：统计模块</li>
 * <li>04：财务模块</li>
 * <li>05：应用模块</li>
 * <li>06：标签模块</li>
 * <li>07：系统配置模块</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 应用级错误（参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）</li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）</li>
 * </ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：000</li>
 * <li>通用的未知错误码：999</li>
 * </ul>
 * <ul>
 * 业务前缀
 * <li>tuia-core：TC_</li>
 * </ul>
 * 
 * @规范： http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @汇总文档：http://cf.dui88.com/pages/viewpage.action?pageId=3560274
 */
public enum ErrorCode {

    // 公共模块00
    /** 成功. */
    E0000000("0000000", "成功"),

    /** 数据库异常. */
    E0000001("0100001", "数据库异常"),
    
    E9999999("9999999", "未知错误"),
    
    /** 数据库错误. */
    E0002001("0002001", "数据库错误"),
    
    /** 调用发号器生成全局ID失败. */
    E0003002("0003002", "调用发号器生成全局ID失败"),
    
    /** OSS上传文件失败. */
    E0003003("0003003", "OSS上传文件失败"),
    
    /** 文件不存在. */
    E0002004("0002004", "文件不存在"),
    
    /** 参数错误. */
    E0001005("0001005", "参数错误"),

    /** IO异常 */
    E0002006("0002006", "IO异常"),
    
    /** 缓存数据格式异常 */
    E0002007("0002007", "缓存数据格式异常"),
    
    /** 发生卡夫卡消息失败 */
    E0002008("0002008", "发生卡夫卡消息失败"),
    
    /** 缓存加载异常 */
    E0002009("0002009", "缓存加载异常"),

    /** 数据转换异常 */
    E0002010("0002010", "数据转换异常"),

    
    // 用户模块01
    /** 该用户不存在. */
    E0200000("0100000", "该用户不存在"),

    /** 用户名或密码错误. */
    E0200001("0100001", "用户名或密码错误"),

    /** 发送邮件失败. */
    E0200002("0100002", "发送邮件失败"),

    /** 邮箱和密码都不能为空. */
    E0200003("0100003", "邮箱和密码都不能为空"),

    /** 新密码不能为空. */
    E0200004("0100004", "新密码不能为空"),

    /** 用户ID不能为空. */
    E0200005("0100005", "用户ID不能为空"),

    /** 您的邮箱尚未验证. */
    E0200006("0100006", "您的邮箱尚未验证"),

    /** 您的邮箱处于非法的验证状态. */
    E0200007("0100007", "您的邮箱处于非法的验证状态"),

    /** 您的账号在审核中. */
    E0200008("0100008", "您的账号在审核中"),

    /** 您的账号审核未通过. */
    E0200009("0100009", "您的账号审核未通过"),

    /** 您的账号处于非法的审核状态. */
    E0200010("0100010", "您的账号处于非法的审核状态"),

    /** 您的账号被冻结. */
    E0200011("0100011", "您的账号被冻结"),

    /** 您的账号处于非法的冻结状态. */
    E0200012("0100012", "您的账号处于非法的冻结状态"),

    /** 该邮箱账号已注册. */
    E0200013("0100013", "该邮箱账号已注册"),

    /** 发送重置密码邮件失败，邮件为空. */
    E0200014("0100014", "发送重置密码邮件失败，邮件为空"),

    /** 该链接已失效，请重新发送. */
    E0200015("0100015", "该链接已失效，请重新发送"),

    /** 该账号已验证. */
    E0200016("0100016", "该账号已验证"),

    /** 请重新登录. */
    E0200017("0100017", "请重新登录"),

    /** 参数错误, 邮箱不能为空. */
    E0200018("0100018", "参数错误, 邮箱不能为空"),

    /** 已登录，请重定向首页. */
    E0200019("0100019", "已登录，请重定向首页"),

    /** 发送重置密码邮件失败，验证码信息为空. */
    E0200020("0100020", "发送重置密码邮件失败，验证码信息为空"),

    /** 距离上次发送未过一分钟. */
    E0200021("0100021", "距离上次发送未过一分钟"),

    /** 该用户没有资金账户. */
    E0200022("0100022", "该用户没有资金账户"),

    /** 新密码不能和旧密码一致. */
    E0200023("0100023", "新密码不能和旧密码一致"),
    
    /** 抱歉！您没有绑定广告主，暂不能登录. */
    E0200024("0100024", "抱歉！您没有绑定广告主，暂不能登录"),
    
    /** 抱歉！您和选中的广告主没有被绑定关系. */
    E0200025("0100025", "抱歉！您和选中的广告主没有被绑定关系"),
    
    /** 该邮箱已被非协作员用户占用. */
    E0200026("0100026", "该邮箱已被非协作员用户占用"),
    
    /** 绑定超时， 请重新绑定. */
    E0200027("0100027", "绑定超时， 请重新绑定"),
    
    /** 该协作员与广告主已经绑定过. */
    E0200028("0100028", "该协作员与广告主已经绑定过"),
    
    /** 该协作员已存在. */
    E0200029("0100029", "该协作员已存在"),
    
    /** 协作员没有绑定广告主. */
    E0200030("0100030", "协作员没有绑定广告主"),
    
    /** 广告主删除协作员失败. */
    E0200031("0100031", "广告主删除协作员失败"),
    
    /** 抱歉， 您没有权限访问该接口. */
    E0200032("0100032", "抱歉， 您没有权限访问该接口"),
    
    /** 您已经被当前绑定的广告主解绑. */
    E0200033("0100033", "您已经被当前绑定的广告主解绑"),
    
    /** 您的账号已被冻结， 请重新登录. */
    E0200034("0100034", "您的账号已被冻结， 请重新登录"),
    
    /** 您的账号已被注销， 请重新登录. */
    E0200035("0100035", "您的账号已被注销， 请重新登录"),
    
    /** 您的账号已被广告主暂停. */
    E0200036("0100036", "您的账号已被广告主暂停"),
    /** 定向配置不存在. */
    E0200037("0200037", "该定向配置不存在"),

    /** 发送邮件时默认的发件人信息未配置 */
    E0200038("0200038", "默认系统发件人信息未配置"),

    /** 广告主不存在. */
    E0104037("0104037", "广告主不存在"),
    
    /** 广告主所属的代理商和当前代理商不一致. */
    E0104038("0104038", "广告主所属的代理商和当前代理商不一致"),

    /** 扣除金额超过账户余额 ,请重新输入 */
    E0104039("E0104039", "扣除金额超过账户余额,请重新输入"),
    
    /** 非法的传入类型. */
    E0101039("0101039", "非法的传入类型"),
    
    /** 非审核拒绝的账号不可修改审核信息. */
    E0102040("0102040", "非审核拒绝的账号不可修改审核信息"),

    /** 该用户状态异常. */
    E0102041("0102041", "该用户状态异常"),
    
    /** 公司名被占用. */
    E0104042("0104042", "公司名被占用"),
    
    /** 该操作员不属于代理商. */
    E0104043("0104043", "该操作员不属于代理商"),

    // 广告模块02 
    /** 创建劵码失败. */
    E0203000("0203000", "创建劵码失败"),
    
    /** 创建批次失败. */
    E0203001("0203001", "创建批次失败"),
    
    /** 广告主的广告不能重名. */
    E0201002("0201002", "广告主的广告不能重名"),
    
    /** 广告不存在. */
    E0204003("0204003", "广告不存在"),
    
    /** 查询批次数据失败. */
    E0203004("0203004", "查询批次数据失败"),
    
    /** 查询库存失败. */
    E0203005("0203005", "查询库存失败"),
    
    /** 查询优惠码数据失败. */
    E0203006("0203006", "查询优惠码数据失败"),

    E0203007("0203007", "广告不存在或已被删除"),

    /** 审核中的广告不允许被修改. */
    E0204007("0204007", "审核中的广告不允许被修改"),
    
    /** 审核通过过的广告不允许修改：领取次数限制、有效期、券码类型. */
    E0204008("0204008", "审核通过过的广告不允许修改：领取次数限制、有效期、券码类型"),
    
    /** 未审核通过过的广告优惠卷批次数量不能大于1. */
    E0204009("0204009", "未审核通过过的广告优惠卷批次数量不能大于1"),
    
    /** 更新优惠券数据失败. */
    E0203010("0203010", "更新优惠券数据失败"),
    
    /** 优惠券有效期的截至日期不可早于当天. */
    E0201011("0201011", "优惠券有效期的截至日期不可早于当天"),
    
    /** 未查到该优惠券信息. */
    E0204012("0204012", "未查到该优惠券信息"),
    
    /** 更新库存数据失败. */
    E0204013("0204013", "更新库存数据失败"),
    
    /** 更新批次数据失败. */
    E0204014("0204014", "更新批次数据失败"),
    
    /** 更新优惠券有效期数据失败. */
    E0204015("0204015", "更新优惠券有效期数据失败"),
    
    /** 数据格式错误 */
    E0201016("0201016", "数据格式错误"),
    
    /** 导入券码失败. */
    E0203017("0203017", "导入券码失败"),
    
    /** 获取商品中心导入券码数量失败. */
    E0203018("0203018", "查询导入券码数量失败"),
    
    /** 新增上传记录失败. */
    E0202019("0202019", "新增上传记录失败"),
    
    /** 广告单价不能小于限制. */
    E0204020("0204020", "广告单价不能小于限制"),
    
    /**该广告已存在关联关系,不可重复关联*/
    E0204021("0204021", "该广告已存在关联关系,不可重复关联"),
    
    /**查询兑吧商品失败*/
    E0204022("0204022", "查询兑吧广告失败"),
    
    /**广告ID有误,请重新输入*/
    E0204023("0204023", "该兑吧广告不存在"),
    
    /**兑吧广告没有开启计费开关*/
    E0204024("0204024", "该兑吧广告没有开启计费开关"),
    
    /**兑吧广告已删除*/
    E0204025("0204025", "该兑吧广告已删除"),
    
    /**曾激活过的素材不可修改*/
    E0202026("0202026", "曾激活过的素材不可修改"),
    
    /** 该广告最多只能设置100个定向媒体. */
    E0202027("0202027", "该广告最多只能设置100个定向媒体"),

    E0202028("0202028", "该流量包已经存在"),
    E0202029("0202029", "该流量包不存在"),
    E0202030("0202030", "流量包媒体个数超过限制"),
    E0200066("0200066", "角色不能重名"),
    E0200067("0200067", "出价低于兑吧CPC最低价"),

    E0200068("E0200068", "开启失败，该广告配置预算不符合新广告扶持条件"),
    E0200069("E0200069", "开启失败，该广告扶持发券数已达上限"),
    E0200070("E0200070", "开启失败，已有其他广告或配置开启新广告扶持"),
    E0200071("E0200071", "开启失败，该广告转化PV>100，建议使用自动托管功能"),
    E0200072("E0200072", "开启失败，微信加粉广告不能开启新广告扶持"),
    E0200073("E0200073", "开启失败，不是新广告主无法开启新广告扶持"),
    E0200074("E0200074", "开启失败，该广告主预算不符合新广告扶持条件"),
    E0200075("E0200075", "开启失败，广告无考核成本无法开启新广告扶持"),
    E0200076("E0200076", "开启失败，该广告对应行业无优质媒体"),
    E0200077("E0200077", "开启失败，该广告已扶持过并且超过了3天"),

    // 统计模块 03

    // 财务模块04
    /** 新增上传记录失败. */
    E0402001("0402001", "账户余额不足"),
    /** 订单编号重复 */
    E0402002("0402002", "订单已经生成,请勿重复点击"),
    /** 生成订单失败 */
    E0402003("0402003", "生成订单失败,订单可能已经生成"),

    // 应用模块05
    /** 媒体流量策略不存在. */
    E0504001("0504001", "媒体流量策略不存在"),


    /** 添加特权广告失败. */
    E0500033("0500033", "添加特权广告失败,可能已经存在"),
    /** 移除特权广告失败. */
    E0500034("0500034", "移除特权广告失败"),
    /** 添加特权媒体失败. */
    E0500035("0500035", "添加特权媒体失败,可能已经存在"),
    /** 移除特权媒体失败. */
    E0500036("0500036", "移除媒体广告失败"),
    // 标签模块06
    /** 分类名不可重复. */
    E0604001("0604001", "分类名不可重复"),
    
    /** 父级标签(分类)不存在. */
    E0604002("0604002", "父级标签(分类)不存在"),

    /** 标签级别和父级ID不匹配. */
    E0604003("0604003", "标签级别和父级ID不匹配"),
    
    /** 修改分类名失败. */
    E0602004("0602004", "修改分类名失败"),

    /** 该分类不存在. */
    E0604005("0604005", "该分类不存在"),

    /** 标签名不可修改. */
    E0604006("0604006", "标签名不可修改"),
    
    /** 分类不可删除. */
    E0604007("0604007", "分类不可删除"),
    
    /** 该标签不存在. */
    E0604008("0604008", "该标签不存在"),
    
    /** 不允许新增分组. */
    E0604009("0604009", "不允许新增分组"),
    
    /** 二级标签太多， 请在新的分类中添加. */
    E0604010("0604010", "二级标签太多， 请在新的分类中添加"),

    E0604011("E0604011", "您当前可分配给该账户的余额最多为%s元"),
    /**批量修改定向配置中的屏蔽流量*/
    E0604012("E0604012","批量修改定向配置中的屏蔽流量"),
    /** 流量包被引用则不允许将下面的媒体删光*/
    E0604013("E0604013","删除失败,使用中的流量包不允许成为空包"),
    /** 推荐流量包规则已经绑定*/
    E0604014("E0604014","推荐流量包规则已经绑定"),
    /** 当前流量包没有推荐过*/
    E0604015("E0604015","当前流量包没有推荐过"),
    ;

    /** 错误码. */
    private String errorCode;//NOSONAR

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     * @param desc the desc
     */
    private ErrorCode(String errorCode, String desc) {
        this.errorCode = "TC-" + errorCode;
        this.desc = desc;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
