/**
 * Project Name:goods-center-common File Name:GoodsException.java Package Name:cn.com.duiba.goods.center.common
 * Date:2016年5月25日下午1:33:07 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.common;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 推啊core模块内部异常 .
 * 
 * @author: leiliang
 * @version:
 */
public class TuiaCoreException extends Exception {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 4488920747852502701L;

    /** The result code. */
    private final String      resultCode;

    /** The result message. */
    private final String      resultMessage;

    /**
     * The Constructor.
     * 
     * @param code the code
     */
    public TuiaCoreException(ErrorCode code) {
        super(code.getDesc());
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * Creates a new instance of GoodsException.
     *
     * @param code the code
     * @param desc the desc
     */

    public TuiaCoreException(String code, String desc) {
        super();
        this.resultCode = code;
        this.resultMessage = desc;
    }

    /**
     * The Constructor.
     * 
     * @param code the code
     * @param cause the cause
     */
    public TuiaCoreException(ErrorCode code, Throwable cause) {
        super(cause);
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * Gets the result code.
     * 
     * @return the resultCode
     */
    public String getResultCode() {
        return resultCode;
    }

    /**
     * Gets the result message.
     * 
     * @return the resultMessage
     */
    public String getResultMessage() {
        return resultMessage;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
