package cn.com.duiba.tuia.core.util;

import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * Created by huangch on 2017/8/18 17:52
 * description: 对象转换工具类，如DO转换为DTO
 *
 * @since JDK 1.6
 */
public class BeanTranslateUtil {

    private BeanTranslateUtil() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 两个List对象之间的转换
     *
     * @param sourceList 原对象列表
     * @param clazz      目标对象类型
     * @return
     */
    public static <T, S> List<T> translateListObject(List<S> sourceList, Class<T> clazz) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        String str = JSON.toJSONString(sourceList);
        return JSON.parseArray(str, clazz);
    }

    /**
     * 单个JavaBean之间的转换
     *
     * @param source 原对象
     * @param clazz  目标对象类型
     * @return
     */
    public static <T, S> T translateObject(S source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        String str = JSON.toJSONString(source);
        return JSON.parseObject(str, clazz);
    }

}
