package cn.com.duiba.tuia.core.util;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.List;

public class HbaseUtil {

    private final static String joiner = "-";

    
    /**
     * rowKey: advert_id(反转) + "-" +activitytype+ "-" + {yyyyMMdd} + "-" + app_id  广告-媒体-活动类型维度
     *
     * @param advertId
     * @param appId
     * @return
     */
    public static String buildRowKey(Long advertId, Long appId, Integer type) {

        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(type);
        //当前时间
        String today = String.valueOf(DateUtils.getDayNumber(new Date()));
        rowkeyBuffer.append(joiner).append(today).append(joiner);
        if (appId != null) {
            rowkeyBuffer.append(String.valueOf(appId));
        }

        return rowkeyBuffer.toString();
    }

    public static String buildRowKey(Long advertId, Long appId, Integer type, Date date) {
        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(type);
        //日期
        String today = String.valueOf(DateUtils.getDayNumber(date));
        rowkeyBuffer.append(joiner).append(today).append(joiner);
        if (appId != null) {
            rowkeyBuffer.append(String.valueOf(appId));
        }

        return rowkeyBuffer.toString();
    }

    /**
     * rowKey: advert_id(反转) + "-" + app_id "-" + {yyyyMMdd} + "-" + "00"  广告-媒体-日期－时段维度
     *
     * @param advertId
     * @param appId
     * @return
     */
    public static String buildHourRowKey(Long advertId, Long appId, String curDate, String curHour) {

        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        rowkeyBuffer.append(joiner).append(appId);
        //当前时间
        String today = String.valueOf(DateUtils.getDayNumber(DateUtils.getDayDate(curDate)));
        rowkeyBuffer.append(joiner).append(today).append(joiner).append(curHour);

        return rowkeyBuffer.toString();
    }

    /**
     * rowKey: advert_id(反转) + "-" + {yyyyMMdd}  广告下所有的媒体
     *
     * @param advertId
     * @return
     */
    public static String buildRowKey(Long advertId) {

        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        //当前时间
        String today = String.valueOf(DateUtils.getDayNumber(new Date()));
        rowkeyBuffer.append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    public static String buildRowKey(Long advertId, Date date) {
        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        //时间
        String today = String.valueOf(DateUtils.getDayNumber(date));
        rowkeyBuffer.append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    /**
     * rowKey:advert_id(反转) + "-" + slotId + "-" + {yyyyMMdd}
     * @param advertId
     * @param slotId
     * @return
     */
    public static String buildSlotRowKey(Long advertId, Long slotId) {

        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();
        //当前时间
        String today = String.valueOf(DateUtils.getDayNumber(new Date()));
        rowkeyBuffer.append(joiner).append(slotId).append(joiner).append(today);
        return rowkeyBuffer.toString();
    }

    /**
     * rowKey: advert_id(反转) + "-" + app_id + "-" +  {yyyyMMddHHmm} 广告媒体维度
     *
     * @param advertId
     * @param appId
     * @return
     */
    public static String buildEveryMinuteRowKey(Long advertId, Long appId,String dateTime) {

        //反转广告ID
        StringBuffer rowkeyBuffer = new StringBuffer(String.valueOf(advertId)).reverse();

        if (appId != null) {
            rowkeyBuffer.append(joiner).append(String.valueOf(appId));
        }

        //当前时间
        rowkeyBuffer.append(joiner).append(dateTime);
        return rowkeyBuffer.toString();
    }

    /**
     * 通过rowKey 获取媒体ID
     *
     * @param rowKey
     * @return
     */
    public static Long getAppIdByEveryMinuteRowKey(String rowKey) {

        List<String> stringList = Splitter.on(joiner).splitToList(rowKey);
        String appId = stringList.get(1);
        return Long.parseLong(appId);
    }

    /**
     * 通过rowKey 获取媒体ID
     *
     * @param rowKey
     * @return
     */
    public static Long getAppIdByRowKey(String rowKey) {

        List<String> stringList = Splitter.on(joiner).splitToList(rowKey);

        String activityTypeStr = stringList.get(1);
        Integer activityType = -1;
        if (StringUtils.isNotBlank(activityTypeStr)) {
            activityType = Integer.parseInt(activityTypeStr);
        }

        int index = (activityType == -1 ? 4 : 3);

        String appId = stringList.get(index);
        return Long.parseLong(appId);
    }

    /**
     * 通过rowKey获取slotId   xxx-slotId-yyyyMMdd
     * @param rowKey
     * @return
     */
    public static Long getSlotIdByRowKey(String rowKey) {

        List<String> stringList = Splitter.on(joiner).splitToList(rowKey);
        String slotId = stringList.get(1);

        return Long.parseLong(slotId);
    }

    /**
     * 根据rowKey解析出curHour
     * advertId反转-appId-yyyyMMdd-00
     * @param rowKey
     * @return
     */
    public static String getCurHourByRowKey(String rowKey) {

        List<String> stringList = Splitter.on(joiner).splitToList(rowKey);

        String curHour = stringList.get(stringList.size() - 1);
        return curHour;
    }

    /**
     * 通过rowKey 获取媒体ID
     *
     * @param rowKey
     * @return
     */
    public static Long getAdvertIdByRowKey(String rowKey) {

        List<String> stringList = Splitter.on(joiner).splitToList(rowKey);
        String advertId = new StringBuffer(stringList.get(0)).reverse().toString();
        return Long.parseLong(advertId);
    }

}
