package cn.com.duiba.tuia.adx.center.api.bean.enums.adx;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * adx 创意竞价类型
 *
 * @author peanut.huang
 * @date 2020/1/9 10:48
 */
public enum IdeaBidTypeEnum {

    /**
     *
     */
    INTERACT(0, "互动活动"),

    DIRECTLY(1,"直投广告")
    ;

    /**
     * 编码
     */
    @Getter
    private Integer  code;

    /**
     * 描述
     */
    @Getter
    private String  desc;

    IdeaBidTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据编码获取创意竞价类型
     *
     * @param code
     * @return
     */
    public static IdeaBidTypeEnum findByCode(Integer code){
        if(code == null){
            return null;
        }

        return Stream.of(IdeaBidTypeEnum.values()).filter(e -> e.getCode().equals(code))
                    .findFirst().orElse(null);
    }

}
