package cn.com.duiba.tuia.adx.center.api.constant;

public enum BalanceType {
    NORMAL(0, "正常", 100),

    CASH(1, "现金", 100),

    GAME(2, "游戏币", 10000),

    RED_PACKET(3,"瓜分红包",100),

    YOUTUI_MONEY(10,"友推余额",100),
    ;

    private Integer type;
    private String desc;
    // 汇率
    private Integer rate;

    BalanceType(Integer type, String desc, Integer rate) {
        this.type = type;
        this.desc = desc;
        this.rate = rate;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getRate() {
        return rate;
    }

    public static BalanceType getEnumByType(Integer type) {
        for (BalanceType s : BalanceType.values()) {
            if (s.type.equals(type)) {
                return s;
            }
        }
        return NORMAL;
    }
}
