package cn.com.duiba.tuia.adx.center.api.constant;

public enum GameVersion {
    /**
     * 默认捕鱼版本，初始版本
     */
    FishV1("1.0","V1.0 2月1日"),

    FishV1_1("1.1","V1.1 6月7日 按钮缩放"),
    FishV1_2("1.2","V1.2 6月7日 按钮手势"),
    /**
     * 升级排行榜和结果页，增加特殊怪物 http://cf.dui88.com/pages/viewpage.action?pageId=8528497
     */
    FishV2("2.0","V2.0 5月1日"),
    FishV2_1("2.1","V2.1 6月7日 圆形按钮+光效"),
    FishV2_2("2.2","V2.2 6月7日 圆形按钮+手势"),
    FishV2_3("2.3","V2.3 6月7日 文字按钮+手势"),
    FishV2_4("2.4","V2.4 6月7日 文字按钮+缩放"),
    FishV3("3.0","V3.0 6月7日 货币单位为人民币"),
    FishV4("4.0","V4.0 6月7日 宝箱怪+新用户免费射击"),

    /**
     * 未知版本
     */
    NULL("0.0","未知版本");
    private String version;
    private String versionDec;

    GameVersion(String version, String versionDec) {
        this.version = version;
        this.versionDec = versionDec;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersionDec() {
        return versionDec;
    }

    public void setVersionDec(String versionDec) {
        this.versionDec = versionDec;
    }
    public static GameVersion getGameVersion(String version) {
        for (GameVersion gameVersion : GameVersion.values()) {
            if (gameVersion.getVersion().equals(version)) {
                return gameVersion;
            }
        }
        return NULL;
    }
}
