package cn.com.duiba.tuia.adx.center.api.constant.story.lucky;

import java.util.HashMap;
import java.util.Map;

/**
 * LuckyDrawDetailPrizeType
 *
 * @author huangruodan
 * @date 2019/5/22
 */


public enum LuckyDrawDetailPrizeType {

    CASH(1, "现金", 100, 100, 1),
    TEN_TO_THIRTY_COINS(2, "10~30金币", 10, 30, 2),
    ONE_HUNDRED_COINS(3, "100金币", 100, 100, 2),
    LUCKY(4, "福袋", 0, 0, 3),
    THANKS(5, "谢谢参与", 0, 0, 4);

    private Integer type;

    private String desc;

    private Integer rangeStart;

    private Integer rangeEnd;

    private Integer storyPrizeType;


    private final static Map<Integer, LuckyDrawDetailPrizeType> detailPrizeTypeMap = new HashMap<>(4);
    static{
        detailPrizeTypeMap.put(CASH.getType(), CASH);
        detailPrizeTypeMap.put(TEN_TO_THIRTY_COINS.getType(), TEN_TO_THIRTY_COINS);
        detailPrizeTypeMap.put(ONE_HUNDRED_COINS.getType(), ONE_HUNDRED_COINS);
        detailPrizeTypeMap.put(LUCKY.getType(), LUCKY);
        detailPrizeTypeMap.put(THANKS.getType(), THANKS);
    }

    LuckyDrawDetailPrizeType(Integer type, String desc, Integer rangeStart, Integer rangeEnd, Integer storyPrizeType) {
        this.type = type;
        this.desc = desc;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.storyPrizeType = storyPrizeType;
    }

    public static LuckyDrawDetailPrizeType getByType(Integer type) {
        LuckyDrawDetailPrizeType prizeType =  detailPrizeTypeMap.get(type);
        return prizeType == null ? THANKS : prizeType;
    }

    public Integer getStoryPrizeType() {
        return storyPrizeType;
    }

    public void setStoryPrizeType(Integer storyPrizeType) {
        this.storyPrizeType = storyPrizeType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getRangeStart() {
        return rangeStart;
    }

    public void setRangeStart(Integer rangeStart) {
        this.rangeStart = rangeStart;
    }

    public Integer getRangeEnd() {
        return rangeEnd;
    }

    public void setRangeEnd(Integer rangeEnd) {
        this.rangeEnd = rangeEnd;
    }
}
