package cn.com.duiba.tuia.adx.center.api.constant.story.tree;

import org.apache.commons.lang3.RandomUtils;

/**
 * [深度互动故事完整性]果实类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/06/03
 */
public enum FruitType {

    DEFAULT(1, "默认果实"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String  desc;

    FruitType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算果实的成熟时间
     *
     * @param times 当天第几次种
     * @return 成熟时间(秒)
     */
    public int countMatureTime(int times) {
        int matureTime = 0;

        switch (this) {
            case DEFAULT:
                if (times <= 3) {
                    matureTime = RandomUtils.nextInt(8, 16);
                } else if (times <= 6) {
                    matureTime = RandomUtils.nextInt(20, 31);
                } else if (times <= 10) {
                    matureTime = RandomUtils.nextInt(60, 181);
                } else if (times <= 20) {
                    matureTime = RandomUtils.nextInt(300, 901);
                } else {
                    matureTime = RandomUtils.nextInt(3600, 10800);
                }
                break;
            default:
                break;
        }
        return matureTime;
    }
}
