/**
 * Project Name:activity-center-api<br>
 * File Name:GuidePageDto.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月3日下午2:12:41<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.adx.center.api.dto;

import cn.com.duiba.tuia.adx.center.api.dto.req.ReqDirectBlock;
import cn.com.duiba.tuia.adx.center.api.dto.risk.AuditDto;
import cn.com.duiba.tuia.adx.center.api.constant.BalanceType;
import cn.com.duiba.tuia.adx.center.api.constant.IsReward;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: GuidePageDto <br/>
 * 引导页dto date: 2017年3月3日 下午2:12:41 <br/>
 *
 * @author youhaijun
 * @version
 * @since JDK 1.6
 */
public class GuidePageDto extends AuditDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 7720922780320322944L;

    private Long              id;

    private String            title;

    private Integer           pageType;

    private Long              skinId;

    private Boolean           isDeleted;

    private List<Long>        activityIds;

    private List<GuidePageRelationDto> activitys;

    private ReqDirectBlock reqDirectBlock;

    private List<DirectGuidePageDTO> directGuidePageDTOList;



    /** 是否默认直投页 */
    private Boolean           isDefault;

    private List<Long> buoyList;//定制浮标列表

    private ExtInfo extInfo;

    private GuidePageMoneyConfigDto guidePageMoneyConfigDto;

    public List<Long> getBuoyList() {
        return buoyList;
    }

    public void setBuoyList(List<Long> buoyList) {
        this.buoyList = buoyList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public Boolean getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public List<GuidePageRelationDto> getActivitys() {
        return activitys;
    }

    public void setActivitys(List<GuidePageRelationDto> activitys) {
        this.activitys = activitys;
    }

    public Boolean getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ReqDirectBlock getReqDirectBlock() {
        return reqDirectBlock;
    }

    public void setReqDirectBlock(ReqDirectBlock reqDirectBlock) {
        this.reqDirectBlock = reqDirectBlock;
    }

    public List<DirectGuidePageDTO> getDirectGuidePageDTOList() {
        return directGuidePageDTOList;
    }

    public void setDirectGuidePageDTOList(List<DirectGuidePageDTO> directGuidePageDTOList) {
        this.directGuidePageDTOList = directGuidePageDTOList;
    }

    public ExtInfo getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(ExtInfo extInfo) {
        this.extInfo = extInfo;
    }

    public GuidePageMoneyConfigDto getGuidePageMoneyConfigDto() {
        return guidePageMoneyConfigDto;
    }

    public void setGuidePageMoneyConfigDto(GuidePageMoneyConfigDto guidePageMoneyConfigDto) {
        this.guidePageMoneyConfigDto = guidePageMoneyConfigDto;
    }

    public static class ExtInfo implements Serializable {
        private static final long serialVersionUID = -5547493150269221414L;

        /**
         * @see BalanceType
         */
        private Integer directType;
        /**
         * @see IsReward
         */
        private Integer isReward;

        /** 汇率，兑换人民币分*/
        private Integer exchangeRate;
        /** 首次赠送*/
        private Long firstGive;
        /** 每日赠送*/
        private Long dailyGive;

        //瓜分红包配置字段
        /** 总额（单位：分）*/
        private Integer redTotalMoney;

        /** 瓜分时间*/
        private String redLimitTime;

        /** 单个红包最大值（单位：分）*/
        private Integer redMaxMoney;

        /** 游戏厅预算上限 */
        private Double preinstallMoney;

        /** 游戏厅说明 */
        private String gameHallDesc;

        /** 积分商城配置 appkey */
        private String duibaAppkey;

        /** 积分商城配置 appsecret */
        private String duibaAppsecret;

        public String getGameHallDesc() {
            return gameHallDesc;
        }

        public void setGameHallDesc(String gameHallDesc) {
            this.gameHallDesc = gameHallDesc;
        }

        public Double getPreinstallMoney() {
            return preinstallMoney;
        }

        public void setPreinstallMoney(Double preinstallMoney) {
            this.preinstallMoney = preinstallMoney;
        }

        public Integer getExchangeRate() {
            return exchangeRate;
        }

        public void setExchangeRate(Integer exchangeRate) {
            this.exchangeRate = exchangeRate;
        }

        public Long getFirstGive() {
            return firstGive;
        }

        public String getDuibaAppkey() {
            return duibaAppkey;
        }

        public void setDuibaAppkey(String duibaAppkey) {
            this.duibaAppkey = duibaAppkey;
        }

        public String getDuibaAppsecret() {
            return duibaAppsecret;
        }

        public void setDuibaAppsecret(String duibaAppsecret) {
            this.duibaAppsecret = duibaAppsecret;
        }

        public void setFirstGive(Long firstGive) {
            if (firstGive == null) {
                firstGive = 0L;
            }
            this.firstGive = firstGive;
        }

        public Long getDailyGive() {
            return dailyGive;
        }

        public void setDailyGive(Long dailyGive) {
            if (dailyGive == null) {
                dailyGive = 0L;
            }
            this.dailyGive = dailyGive;
        }

        public Integer getDirectType() {
            return directType;
        }

        public void setDirectType(Integer directType) {
            this.directType = directType;
        }

        public Integer getIsReward() {
            return isReward;
        }

        public void setIsReward(Integer isReward) {
            this.isReward = isReward;
        }

        public Integer getRedTotalMoney() {
            return redTotalMoney;
        }

        public void setRedTotalMoney(Integer redTotalMoney) {
            this.redTotalMoney = redTotalMoney;
        }

        public String getRedLimitTime() {
            return redLimitTime;
        }

        public void setRedLimitTime(String redLimitTime) {
            this.redLimitTime = redLimitTime;
        }

        public Integer getRedMaxMoney() {
            return redMaxMoney;
        }

        public void setRedMaxMoney(Integer redMaxMoney) {
            this.redMaxMoney = redMaxMoney;
        }
    }
}
